<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Detail Pegawai
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow overflow-hidden sm:rounded-lg p-6">

                <div class="flex justify-between items-center mb-4">
                    <a href="<?php echo e(route('pegawai.index')); ?>" class="inline-block px-4 py-2 bg-gray-200 text-sm rounded hover:bg-gray-300">Kembali</a>
                    <div class="space-x-2">
                        <a href="<?php echo e(route('pegawai.edit', $pegawai->id)); ?>" class="px-4 py-2 bg-green-500 text-white text-sm rounded hover:bg-green-600">Ubah</a>
                        <form action="<?php echo e(route('pegawai.destroy', $pegawai->id)); ?>" method="POST" class="inline-block" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="px-4 py-2 bg-red-500 text-white text-sm rounded hover:bg-red-600">Hapus</button>
                        </form>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                    <div><p class="font-semibold">Nama Lengkap</p><p><?php echo e($pegawai->nama); ?></p></div>
                    <div><p class="font-semibold">NIP</p><p><?php echo e($pegawai->nip); ?></p></div>
                    <div><p class="font-semibold">Jabatan</p><p><?php echo e($pegawai->jabatan->nama ?? '-'); ?></p></div>
                    <div><p class="font-semibold">Divisi</p><p><?php echo e($pegawai->divisi ?? '-'); ?></p></div>
                    <div><p class="font-semibold">Status Karyawan</p><p><?php echo e($pegawai->status_karyawan); ?></p></div>
                    <div><p class="font-semibold">Status Aktif</p>
                        <?php if($pegawai->status_aktif): ?>
                            <span class="inline-block bg-green-100 text-green-700 px-3 py-1 rounded text-xs">Aktif</span>
                        <?php else: ?>
                            <span class="inline-block bg-red-100 text-red-700 px-3 py-1 rounded text-xs">Nonaktif / Resign</span>
                        <?php endif; ?>
                    </div>
                    <div><p class="font-semibold">Tanggal Masuk</p><p><?php echo e($pegawai->tanggal_masuk ? \Carbon\Carbon::parse($pegawai->tanggal_masuk)->format('d-m-Y') : '-'); ?></p></div>
                    <div><p class="font-semibold">Pendidikan Terakhir</p><p><?php echo e($pegawai->pendidikan_terakhir ?? '-'); ?></p></div>
                    <div><p class="font-semibold">Status PTKP</p><p><?php echo e($pegawai->status_ptkp ?? '-'); ?></p></div>
                </div>

                <div class="mt-6">
                    <form action="<?php echo e(url('gaji/slip-total/' . $pegawai->id . '/pdf')); ?>" method="GET" id="pdfForm" class="flex flex-wrap sm:flex-nowrap sm:items-center gap-2">
                        <label for="tahun" class="text-sm">Pilih Tahun:</label>
                        <select id="tahun" name="tahun" class="border rounded px-3 py-2 min-w-[100px] text-sm bg-white" onchange="updateFormAction()">
                            <?php $__currentLoopData = range(date('Y'), date('Y') - 10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($y); ?>" <?php echo e($y == date('Y') ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded text-sm">Download PDF Tahunan</button>
                    </form>
                    <script>
                        function updateFormAction() {
                            const tahun = document.getElementById('tahun').value;
                            const form = document.getElementById('pdfForm');
                            const base = '<?php echo e(route('gaji.slip_total_pdf', ['pegawai' => $pegawai->id, 'tahun' => 'TAHUN_REPLACE'])); ?>';
                            form.setAttribute('action', base.replace('TAHUN_REPLACE', tahun));
                        }
                        document.addEventListener('DOMContentLoaded', updateFormAction);
                    </script>
                </div>

                
                <div class="mt-10">
                    <h3 class="text-lg font-semibold mb-2">Riwayat Jabatan & Gaji</h3>
                    <?php if($pegawai->jobHistories->isEmpty()): ?>
                        <p class="text-sm text-gray-500">Belum ada riwayat perubahan.</p>
                    <?php else: ?>
                        <div class="overflow-x-auto">
                            <table class="min-w-full border text-sm">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="px-3 py-2 border">Tanggal Berlaku</th>
                                        <th class="px-3 py-2 border">Jabatan Lama</th>
                                        <th class="px-3 py-2 border">Gaji Lama</th>
                                        <th class="px-3 py-2 border">Jabatan Baru</th>
                                        <th class="px-3 py-2 border">Gaji Baru</th>
                                        <th class="px-3 py-2 border">Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $pegawai->jobHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $riwayat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="border px-2"><?php echo e($riwayat->tanggal_berlaku); ?></td>
                                            <td class="border px-2"><?php echo e($riwayat->jabatan_lama ?? '-'); ?></td>
                                            <td class="border px-2">Rp<?php echo e(number_format($riwayat->gaji_lama ?? 0)); ?></td>
                                            <td class="border px-2"><?php echo e($riwayat->jabatan_baru); ?></td>
                                            <td class="border px-2">Rp<?php echo e(number_format($riwayat->gaji_baru)); ?></td>
                                            <td class="border px-2"><?php echo e($riwayat->keterangan ?? '-'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH D:\xampp\htdocs\penggajian-app\resources\views/pegawai/show.blade.php ENDPATH**/ ?>