<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="py-8 bg-gray-100 min-h-screen">
        <div class="pl-4 pr-6">
            <h2 class="text-2xl font-bold text-gray-800 mb-6">Dashboard</h2>

            <!-- Ringkasan Kartu -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">

                <!-- Jumlah Pegawai -->
                <div class="bg-white shadow rounded-lg p-4 flex items-center">
                    <div class="p-3 bg-blue-100 text-blue-600 rounded-full">
                        <i class="fas fa-building fa-lg"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-600">Jumlah Pegawai</p>
                        <p class="text-xl font-semibold text-gray-800"><?php echo e($jumlahPegawai); ?></p>
                    </div>
                </div>

                <!-- Pegawai Aktif -->
                <div class="bg-white shadow rounded-lg p-4 flex items-center">
                    <div class="p-3 bg-green-100 text-green-600 rounded-full">
                        <i class="fas fa-user-check fa-lg"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-600">Pegawai Aktif</p>
                        <p class="text-xl font-semibold text-gray-800"><?php echo e($pegawaiAktif); ?></p>
                    </div>
                </div>

                <!-- Pegawai Non Aktif -->
                <div class="bg-white shadow rounded-lg p-4 flex items-center">
                    <div class="p-3 bg-red-100 text-red-600 rounded-full">
                        <i class="fas fa-user-times fa-lg"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-600">Pegawai Non-Aktif</p>
                        <p class="text-xl font-semibold text-gray-800"><?php echo e($pegawaiNonAktif); ?></p>
                    </div>
                </div>

                <!-- Total Gaji Pokok -->
                <div class="bg-white shadow rounded-lg p-4 flex items-center">
                    <div class="p-3 bg-yellow-100 text-yellow-600 rounded-full">
                        <i class="fas fa-money-bill-wave fa-lg"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-600">Total Gaji Pokok Bulan Ini</p>
                        <p class="text-xl font-semibold text-gray-800">Rp <?php echo e(number_format($totalGajiPokok, 0, ',', '.')); ?></p>
                    </div>
                </div>

                <!-- Total Uang Makan -->
                <div class="bg-white shadow rounded-lg p-4 flex items-center">
                    <div class="p-3 bg-green-100 text-green-600 rounded-full">
                        <i class="fas fa-utensils fa-lg"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-600">Total Uang Makan Bulan Ini</p>
                        <p class="text-xl font-semibold text-gray-800">Rp <?php echo e(number_format($totalUangMakan, 0, ',', '.')); ?></p>
                    </div>
                </div>

                <!-- Total PPh 21 -->
                <div class="bg-white shadow rounded-lg p-4 flex items-center">
                    <div class="p-3 bg-red-100 text-red-600 rounded-full">
                        <i class="fas fa-receipt fa-lg"></i>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm text-gray-600">Total PPh 21 Terpotong</p>
                        <p class="text-xl font-semibold text-gray-800">Rp <?php echo e(number_format($totalPph21, 0, ',', '.')); ?></p>
                    </div>
                </div>
            </div>

            <!-- Grafik Presensi Tahunan -->
            <div class="bg-white shadow rounded-lg p-6">
                <h3 class="text-lg font-semibold text-gray-700 mb-4">Grafik Presensi Pegawai per Bulan (<?php echo e(now()->year); ?>)</h3>
                <canvas id="presensiBulananChart" width="400" height="150"></canvas>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        const grafikPresensi = <?php echo json_encode(array_values($grafikPresensi), 15, 512) ?>;
        const bulanLabels = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'];

        const hadirPerBulan = grafikPresensi.map(item => item.hadir);
        const telatPerBulan = grafikPresensi.map(item => item.telat);

        new Chart(document.getElementById('presensiBulananChart').getContext('2d'), {
            type: 'bar',
            data: {
                labels: bulanLabels,
                datasets: [
                    {
                        label: 'Hadir',
                        data: hadirPerBulan,
                        backgroundColor: '#10B981',
                        borderRadius: 6
                    },
                    {
                        label: 'Telat',
                        data: telatPerBulan,
                        backgroundColor: '#EF4444',
                        borderRadius: 6
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: { precision: 0 }
                    }
                }
            }
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH D:\xampp\htdocs\penggajian-app\resources\views/dashboard.blade.php ENDPATH**/ ?>