<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Detail Pegawai
        </h2>
    </x-slot>

    <div class="py-8">
        <div class="max-w-4xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white shadow overflow-hidden sm:rounded-lg p-6">

                <div class="flex justify-between items-center mb-4">
                    <a href="{{ route('pegawai.index') }}" class="inline-block px-4 py-2 bg-gray-200 text-sm rounded hover:bg-gray-300">Kembali</a>
                    <div class="space-x-2">
                        <a href="{{ route('pegawai.edit', $pegawai->id) }}" class="px-4 py-2 bg-green-500 text-white text-sm rounded hover:bg-green-600">Ubah</a>
                        <form action="{{ route('pegawai.destroy', $pegawai->id) }}" method="POST" class="inline-block" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="px-4 py-2 bg-red-500 text-white text-sm rounded hover:bg-red-600">Hapus</button>
                        </form>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                    <div><p class="font-semibold">Nama Lengkap</p><p>{{ $pegawai->nama }}</p></div>
                    <div><p class="font-semibold">NIP</p><p>{{ $pegawai->nip }}</p></div>
                    <div><p class="font-semibold">Jabatan</p><p>{{ $pegawai->jabatan->nama ?? '-' }}</p></div>
                    <div><p class="font-semibold">Divisi</p><p>{{ $pegawai->divisi ?? '-' }}</p></div>
                    <div><p class="font-semibold">Status Karyawan</p><p>{{ $pegawai->status_karyawan }}</p></div>
                    <div><p class="font-semibold">Status Aktif</p>
                        @if ($pegawai->status_aktif)
                            <span class="inline-block bg-green-100 text-green-700 px-3 py-1 rounded text-xs">Aktif</span>
                        @else
                            <span class="inline-block bg-red-100 text-red-700 px-3 py-1 rounded text-xs">Nonaktif / Resign</span>
                        @endif
                    </div>
                    <div><p class="font-semibold">Tanggal Masuk</p><p>{{ $pegawai->tanggal_masuk ? \Carbon\Carbon::parse($pegawai->tanggal_masuk)->format('d-m-Y') : '-' }}</p></div>
                    <div><p class="font-semibold">Pendidikan Terakhir</p><p>{{ $pegawai->pendidikan_terakhir ?? '-' }}</p></div>
                    <div><p class="font-semibold">Status PTKP</p><p>{{ $pegawai->status_ptkp ?? '-' }}</p></div>
                </div>

                <div class="mt-6">
                    <form action="{{ url('gaji/slip-total/' . $pegawai->id . '/pdf') }}" method="GET" id="pdfForm" class="flex flex-wrap sm:flex-nowrap sm:items-center gap-2">
                        <label for="tahun" class="text-sm">Pilih Tahun:</label>
                        <select id="tahun" name="tahun" class="border rounded px-3 py-2 min-w-[100px] text-sm bg-white" onchange="updateFormAction()">
                            @foreach(range(date('Y'), date('Y') - 10) as $y)
                                <option value="{{ $y }}" {{ $y == date('Y') ? 'selected' : '' }}>{{ $y }}</option>
                            @endforeach
                        </select>
                        <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded text-sm">Download PDF Tahunan</button>
                    </form>
                    <script>
                        function updateFormAction() {
                            const tahun = document.getElementById('tahun').value;
                            const form = document.getElementById('pdfForm');
                            const base = '{{ route('gaji.slip_total_pdf', ['pegawai' => $pegawai->id, 'tahun' => 'TAHUN_REPLACE']) }}';
                            form.setAttribute('action', base.replace('TAHUN_REPLACE', tahun));
                        }
                        document.addEventListener('DOMContentLoaded', updateFormAction);
                    </script>
                </div>

                {{-- Riwayat Jabatan & Gaji --}}
                <div class="mt-10">
                    <h3 class="text-lg font-semibold mb-2">Riwayat Jabatan & Gaji</h3>
                    @if ($pegawai->jobHistories->isEmpty())
                        <p class="text-sm text-gray-500">Belum ada riwayat perubahan.</p>
                    @else
                        <div class="overflow-x-auto">
                            <table class="min-w-full border text-sm">
                                <thead class="bg-gray-100">
                                    <tr>
                                        <th class="px-3 py-2 border">Tanggal Berlaku</th>
                                        <th class="px-3 py-2 border">Jabatan Lama</th>
                                        <th class="px-3 py-2 border">Gaji Lama</th>
                                        <th class="px-3 py-2 border">Jabatan Baru</th>
                                        <th class="px-3 py-2 border">Gaji Baru</th>
                                        <th class="px-3 py-2 border">Keterangan</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($pegawai->jobHistories as $riwayat)
                                        <tr>
                                            <td class="border px-2">{{ $riwayat->tanggal_berlaku }}</td>
                                            <td class="border px-2">{{ $riwayat->jabatan_lama ?? '-' }}</td>
                                            <td class="border px-2">Rp{{ number_format($riwayat->gaji_lama ?? 0) }}</td>
                                            <td class="border px-2">{{ $riwayat->jabatan_baru }}</td>
                                            <td class="border px-2">Rp{{ number_format($riwayat->gaji_baru) }}</td>
                                            <td class="border px-2">{{ $riwayat->keterangan ?? '-' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>
</x-app-layout>
