{{-- resources/views/jabatan/index.blade.php --}}
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Data Jabatan
        </h2>
    </x-slot>

    <div class="py-8 px-6">
        <div class="bg-white shadow-md rounded-lg overflow-hidden">
            <div class="flex items-center justify-between px-4 py-3 bg-gray-50 border-b">
                <a href="{{ route('jabatan.create') }}"
                   class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded shadow text-sm">
                    + Tambah Jabatan
                </a>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-left text-gray-700">
                    <thead class="bg-gray-100 uppercase text-xs text-gray-600 border-b">
                        <tr>
                            <th class="px-4 py-3">No</th>
                            <th class="px-4 py-3">Nama Jabatan</th>
                            <th class="px-4 py-3">Gaji Pokok</th>
                            <th class="px-4 py-3">Transportasi</th>
                            <th class="px-4 py-3 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($jabatans as $jabatan)
                            <tr class="border-t hover:bg-gray-50">
                                <td class="px-4 py-2">{{ $loop->iteration }}</td>
                                <td class="px-4 py-2">{{ $jabatan->nama }}</td>
                                <td class="px-4 py-2">Rp {{ number_format($jabatan->gaji_pokok, 0, ',', '.') }}</td>
                                <td class="px-4 py-2">Rp {{ number_format($jabatan->transportasi ?? 0, 0, ',', '.') }}</td>
                                <td class="px-4 py-2 text-center space-x-2">
                                    <a href="{{ route('jabatan.show', $jabatan) }}"
                                       class="bg-blue-500 hover:bg-blue-600 text-white px-3 py-1 rounded text-xs">
                                        Detail
                                    </a>
                                    <a href="{{ route('jabatan.edit', $jabatan) }}"
                                       class="bg-green-500 hover:bg-green-600 text-white px-3 py-1 rounded text-xs">
                                        Edit
                                    </a>
                                    <form action="{{ route('jabatan.destroy', $jabatan) }}" method="POST"
                                          class="inline"
                                          onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                                class="bg-red-500 hover:bg-red-600 text-white px-3 py-1 rounded text-xs">
                                            Hapus
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-4 py-4 text-center text-gray-500">
                                    Belum ada data jabatan.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="p-4">
                {{ $jabatans->links() }}
            </div>
        </div>
    </div>
</x-app-layout>
