<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Edit Jabatan</h2>
    </x-slot>

    <div class="py-12 px-8">
        <div class="bg-white p-6 rounded shadow">
            @if ($errors->any())
                <div class="mb-4 text-red-600">
                    <ul class="list-disc pl-5">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('jabatan.update', $jabatan) }}" method="POST">
                @csrf
                @method('PUT')

                {{-- Nama Jabatan --}}
                <div class="mb-4">
                    <label for="nama" class="block font-medium">Nama Jabatan</label>
                    <input type="text" name="nama" id="nama" value="{{ old('nama', $jabatan->nama) }}" class="w-full border-gray-300 rounded" required>
                </div>

                {{-- Gaji Pokok --}}
                <div class="mb-4">
                    <label for="gaji_pokok" class="block font-medium">Gaji Pokok</label>
                    <input type="number" name="gaji_pokok" id="gaji_pokok" value="{{ old('gaji_pokok', $jabatan->gaji_pokok) }}" class="w-full border-gray-300 rounded" required>
                </div>

                {{-- Transportasi --}}
                <div class="mb-4">
                    <label for="transportasi" class="block font-medium">Transportasi</label>
                    <input type="number" name="transportasi" id="transportasi" value="{{ old('transportasi', $jabatan->transportasi) }}" class="w-full border-gray-300 rounded" required>
                </div>

                {{-- Tombol --}}
                <div class="mt-6">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Update</button>
                    <a href="{{ route('jabatan.index') }}" class="ml-2 text-gray-600 hover:underline">Batal</a>
                </div>
            </form>
        </div>
    </div>
</x-app-layout>
