<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Laporan Uang Makan
        </h2>
    </x-slot>

    <div class="py-6 px-8">
        {{-- Form Filter --}}
        <form action="{{ route('uangmakan.filter') }}" method="GET" class="mb-6">
            <div class="flex flex-wrap gap-4 items-center">
                <input type="text" name="bulan" value="{{ old('bulan', request('bulan')) }}" placeholder="Bulan (01)"
                    class="border rounded px-3 py-2" required>
                <input type="text" name="tahun" value="{{ old('tahun', request('tahun')) }}" placeholder="Tahun (2025)"
                    class="border rounded px-3 py-2" required>
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
                    Tampilkan
                </button>

                @if(request('bulan') && request('tahun'))
                    <a href="{{ route('uangmakan.cetak', ['bulan' => request('bulan'), 'tahun' => request('tahun')]) }}"
                       class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700"
                       target="_blank">
                        Cetak PDF
                    </a>
                @endif
            </div>
        </form>

        {{-- Data Tabel --}}
        @isset($absensi)
            @if($absensi->count() > 0)
                <div class="bg-white p-4 shadow rounded overflow-x-auto">
                    <table class="w-full border text-sm">
                        <thead class="bg-gray-100">
                            <tr>
                                <th class="border px-2 py-1 text-left">Nama</th>
                                <th class="border px-2 py-1 text-left">NIK</th>
                                <th class="border px-2 py-1 text-left">Jabatan</th>
                                <th class="border px-2 py-1 text-center">Hadir</th>
                                <th class="border px-2 py-1 text-right">Uang Makan / Hari</th>
                                <th class="border px-2 py-1 text-right">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($absensi as $item)
                                <tr>
                                    <td class="border px-2 py-1">{{ $item->user->nama ?? '-' }}</td>
                                    <td class="border px-2 py-1">{{ $item->user->nik ?? '-' }}</td>
                                    <td class="border px-2 py-1">{{ $item->user->jabatan->nama ?? '-' }}</td>
                                    <td class="border px-2 py-1 text-center">{{ $item->hadir }}</td>
                                    <td class="border px-2 py-1 text-right">
                                        Rp {{ number_format($item->user->jabatan->uang_makan ?? 0, 0, ',', '.') }}
                                    </td>
                                    <td class="border px-2 py-1 text-right">
                                        Rp {{ number_format($item->hadir * ($item->user->jabatan->uang_makan ?? 0), 0, ',', '.') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-gray-600 mt-4">
                    Data tidak ditemukan untuk periode tersebut.
                </div>
            @endif
        @endisset
    </div>
</x-app-layout>
