<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Data Gaji – {{ \Carbon\Carbon::parse($periode)->translatedFormat('F Y') }}
        </h2>
    </x-slot>

    <div class="py-6 px-4 sm:px-6 lg:px-8">
        <div class="mb-4 flex justify-between">
            <div class="flex space-x-2">
                <a href="{{ route('gaji.create') }}"
                   class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm">
                    + Tambah Data Gaji
                </a>
                <a href="{{ route('gaji.import') }}"
                   class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded text-sm">
                    📥 Import Excel
                </a>
            </div>
        </div>

        <div class="mb-6">
            <form action="{{ route('gaji.index') }}" method="GET" class="flex flex-col sm:flex-row sm:items-center gap-2">
                <select name="periode" class="border rounded px-4 py-2 text-sm">
                    @foreach ($semuaPeriode as $item)
                        <option value="{{ $item }}" {{ $item == $periode ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::parse($item)->translatedFormat('F Y') }}
                        </option>
                    @endforeach
                </select>
                <button type="submit" class="bg-gray-700 text-white px-3 py-2 rounded text-sm hover:bg-gray-800">
                    Filter
                </button>
            </form>
        </div>

        <div class="bg-white shadow rounded-lg overflow-x-auto">
            <table class="w-full table-auto border text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2 border text-left">#</th>
                        <th class="px-4 py-2 border text-left">Nama Pegawai</th>
                        <th class="px-4 py-2 border text-left">Bulan</th>
                        <th class="px-4 py-2 border text-left">Hadir</th>
                        <th class="px-4 py-2 border text-left">Uang Makan</th>
                        <th class="px-4 py-2 border text-left">Total Gaji</th>
                        <th class="px-4 py-2 border text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($gajis as $index => $gaji)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-2 border">{{ $index + 1 }}</td>
                            <td class="px-4 py-2 border">{{ $gaji->pegawai->nama }}</td>
                            <td class="px-4 py-2 border">{{ $gaji->bulan }}</td>
                            <td class="px-4 py-2 border">{{ $gaji->jumlah_hadir }}</td>
                            <td class="px-4 py-2 border">Rp {{ number_format($gaji->total_uang_makan, 0, ',', '.') }}</td>
                            <td class="px-4 py-2 border">Rp {{ number_format($gaji->total_gaji, 0, ',', '.') }}</td>
                            <td class="px-4 py-2 border text-center">
                                <div class="flex flex-wrap justify-center gap-1">
                                    <a href="{{ route('gaji.show', $gaji->id) }}"
                                       class="bg-blue-500 text-white px-2 py-1 rounded text-xs">Detail</a>
                                    <a href="{{ route('gaji.edit', $gaji->id) }}"
                                       class="bg-yellow-500 text-white px-2 py-1 rounded text-xs">Edit</a>
                                    <form action="{{ route('gaji.destroy', $gaji->id) }}" method="POST"
                                          onsubmit="return confirm('Yakin ingin menghapus?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                                class="bg-red-600 text-white px-2 py-1 rounded text-xs">Hapus</button>
                                    </form>
                                    <a href="{{ route('gaji.slip', $gaji->id) }}"
                                       class="bg-green-600 text-white px-2 py-1 rounded text-xs" target="_blank">
                                        Slip PDF
                                    </a>
                                    <a href="{{ route('gaji.slip_total', $gaji->pegawai_id) }}"
                                       class="bg-gray-700 text-white px-2 py-1 rounded text-xs" target="_blank">
                                        Slip Tahunan
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center py-4 text-gray-500">
                                Tidak ada data gaji untuk periode ini.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</x-app-layout>
