<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Import Data Gaji dari Excel
        </h2>
    </x-slot>

    <div class="py-6 px-6 bg-white shadow rounded">
        @if (session('success'))
            <div class="bg-green-500 text-white p-3 mb-4 rounded">
                {{ session('success') }}
            </div>
        @endif

        @if (session('error'))
            <div class="bg-red-500 text-white p-3 mb-4 rounded">
                {{ session('error') }}
            </div>
        @endif

        <form action="{{ route('gaji.import') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="mb-4">
                <label class="block text-sm font-medium text-gray-700">Upload File Excel</label>
                <input type="file" name="file" accept=".xls,.xlsx"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
            </div>

            <x-primary-button>Import</x-primary-button>
        </form>

        <div class="mt-6 text-sm text-gray-600">
            <strong>Format Template Excel:</strong>
            <ul class="list-disc ml-6 mt-1">
                <li><code>bulan</code> (format: <code>2025-05</code>)</li>
                <li><code>nama_pegawai</code> (cocok dengan data pegawai)</li>
                <li><code>jumlah_hadir</code>, <code>uang_makan</code>, <code>gaji_pokok</code>, <code>potongan</code></li>
            </ul>

            <p class="mt-2">
                <a href="{{ asset('template/template-import-gaji.xlsx') }}"
                    class="text-blue-600 underline hover:text-blue-800">Download Template Excel</a>
            </p>
        </div>
    </div>
</x-app-layout>
