<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTotalPotonganToGajisTable extends Migration
{
    /**
     * Menambahkan kolom total_potongan ke tabel gajis.
     */
    public function up()
    {
        Schema::table('gajis', function (Blueprint $table) {
            if (!Schema::hasColumn('gajis', 'total_potongan')) {
                $table->integer('total_potongan')->default(0)->after('total_uang_makan');
            }
        });
    }

    /**
     * Menghapus kolom total_potongan dari tabel gajis.
     */
    public function down()
    {
        Schema::table('gajis', function (Blueprint $table) {
            if (Schema::hasColumn('gajis', 'total_potongan')) {
                $table->dropColumn('total_potongan');
            }
        });
    }
}
