<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('tunjangans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('gaji_id')->constrained()->onDelete('cascade');
            $table->string('nama');      // contoh: Tunjangan Jabatan, Transportasi
            $table->integer('jumlah');   // nilai nominal
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tunjangans');
    }
};
