<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Tambahkan field status_karyawan, tanggal_masuk, pendidikan_terakhir ke pegawais.
     */
    public function up(): void
    {
        Schema::table('pegawais', function (Blueprint $table) {
            $table->enum('status_karyawan', ['Tetap', 'Kontrak'])->default('Kontrak');
            $table->date('tanggal_masuk')->nullable();
            $table->string('pendidikan_terakhir')->nullable();
        });
    }

    /**
     * Rollback perubahan.
     */
    public function down(): void
    {
        Schema::table('pegawais', function (Blueprint $table) {
            $table->dropColumn(['status_karyawan', 'tanggal_masuk', 'pendidikan_terakhir']);
        });
    }
};
