<?php

namespace App\Imports;

use App\Models\Gaji;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Carbon\Carbon;

class GajiImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $rows)
    {
        foreach ($rows as $row) {
            // Pastikan semua kolom tersedia
            if (!$row['pegawai_id'] || !$row['bulan'] || !$row['jumlah_hadir'] || !$row['total_uang_makan'] || !$row['tanggal']) {
                continue; // Skip baris jika tidak lengkap
            }

            $tanggal = Carbon::parse($row['tanggal']);

            $gaji_pokok = (int) $row['gaji_pokok'];
            $uang_makan = (int) $row['total_uang_makan'];

            Gaji::create([
                'pegawai_id'       => $row['pegawai_id'],
                'bulan'            => $row['bulan'],
                'jumlah_hadir'     => $row['jumlah_hadir'],
                'total_uang_makan' => $uang_makan,
                'tanggal'          => $tanggal,
                'gaji_pokok'       => $gaji_pokok,
                'total_gaji'       => $gaji_pokok + $uang_makan,
            ]);
        }
    }
}
