<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Imports\PegawaiImport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;

class PegawaiImportController extends Controller
{
    /**
     * Tampilkan halaman upload file Excel.
     */
    public function form()
    {
        return view('pegawai.import');
    }

    /**
     * Proses file Excel yang di-upload dan import ke database.
     */
    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls,csv'
        ], [
            'file.required' => 'Silakan pilih file Excel terlebih dahulu.',
            'file.mimes' => 'Format file tidak valid. Gunakan file .xlsx, .xls, atau .csv.',
        ]);

        try {
            $importer = new PegawaiImport();
            Excel::import($importer, $request->file('file'));

            $berhasil = $importer->getBerhasil();
            $gagal = $importer->getGagal();

            $message = "✅ {$berhasil} data pegawai berhasil diimport.";

            if (!empty($gagal)) {
                Log::warning("Import Pegawai: Beberapa baris gagal", $gagal);
                Session::flash('import_errors', $gagal);
                $message .= " ⚠️ " . count($gagal) . " baris gagal diimport. Lihat detail di bawah.";
            }

            return redirect()->route('pegawai.index')->with('success', $message);

        } catch (\Exception $e) {
            Log::error('Import Pegawai: Exception saat import', ['error' => $e->getMessage()]);
            return back()->with('error', '❌ Terjadi kesalahan saat mengimpor: ' . $e->getMessage());
        }
    }
}
