<?php

namespace App\Http\Controllers;

use App\Models\Gaji;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\RekapGajiExport;
use App\Http\Controllers\Controller;

class LaporanController extends Controller
{
    public function index(Request $request)
    {
        $bulan = $request->get('bulan') ?? now()->format('Y-m');

        $rekap = Gaji::with('pegawai')
            ->where('bulan', $bulan)
            ->get();

        return view('laporan.gaji', compact('rekap', 'bulan'));
    }

    public function exportExcel(Request $request)
    {
        $bulan = $request->get('bulan') ?? now()->format('Y-m');

        $gajis = Gaji::with(['pegawai', 'tunjangan', 'potongan'])
            ->where('bulan', $bulan)
            ->get();

        return Excel::download(new RekapGajiExport($gajis, $bulan), 'rekap-gaji-' . $bulan . '.xlsx');
    }
}
