<?php

namespace App\Http\Controllers;

use App\Models\HariLibur;
use Illuminate\Http\Request;

class HariLiburController extends Controller
{
    public function index()
    {
        $hariliburs = HariLibur::orderBy('tanggal')->paginate(10);
        return view('harilibur.index', compact('hariliburs'));
    }

    public function create()
    {
        return view('harilibur.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'tanggal' => 'required|date|unique:hari_liburs,tanggal',
            'keterangan' => 'nullable|string|max:255',
        ]);

        HariLibur::create($request->all());
        return redirect()->route('harilibur.index')->with('success', 'Hari libur berhasil ditambahkan.');
    }

    public function edit(HariLibur $harilibur)
    {
        return view('harilibur.edit', compact('harilibur'));
    }

    public function update(Request $request, HariLibur $harilibur)
    {
        $request->validate([
            'tanggal' => 'required|date|unique:hari_liburs,tanggal,' . $harilibur->id,
            'keterangan' => 'nullable|string|max:255',
        ]);

        $harilibur->update($request->all());
        return redirect()->route('harilibur.index')->with('success', 'Hari libur berhasil diperbarui.');
    }

    public function destroy(HariLibur $harilibur)
    {
        $harilibur->delete();
        return redirect()->route('harilibur.index')->with('success', 'Hari libur berhasil dihapus.');
    }
}
