<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\GajiImport;

class GajiImportController extends Controller
{
    // Menampilkan halaman form import Excel
    public function form()
    {
        return view('gaji.import');
    }

    // Memproses file Excel yang diunggah
    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls,csv',
        ]);

        try {
            Excel::import(new GajiImport, $request->file('file'));
            return redirect()->route('gaji.index')->with('success', 'Data gaji berhasil diimpor.');
        } catch (\Exception $e) {
            return back()->with('error', 'Terjadi kesalahan saat mengimpor: ' . $e->getMessage());
        }
    }
}
