#!C:\Users\liman\AppData\Local\Programs\Python\Python311\python.exe
# # print("Content-Type: text/html\n")
import mysql.connector
import pandas as pd
import sys
from mlxtend.frequent_patterns import fpgrowth, association_rules
from mlxtend.preprocessing import TransactionEncoder
import json
import random

# db_config = {
#                 "host": "34.172.107.253",
#                 "user": "melissa",
#                 "password": "1234",
#                 "database": "dataAnalytics",
#             }
db_config = {
    "host": "localhost",
    "port": 3306,
    "user": "melissa",
    "password": "1234",
    "database": "dataAnalytics",
}
# db_config = {
#                 "host": "localhost",
#                 "user": "root",
#                 "password": "",
#                 "database": "webApp",
#             }


def format_value(value):
    # Check if value is numeric (int or float)
    if isinstance(value, (int, float)):
        # If the value is a whole number, return as is
        if value == int(value):
            return str(value)
        # Otherwise, format to three decimal places
        return "{:.3f}".format(value)
    # If value is not numeric, return as is
    return value


def generate_html_table(filtered_rules, shop_id):
    html_output = f"<br><table id='mbaResult' class='table table-striped'><tr><th onclick='sortTable(0)'>Support</th><th onclick='sortTable(1)'>Lift</th> <th onclick='sortTable(2)'>Confidence</th><th onclick='sortTable(3)'>Set Produk</th></tr>"

    for index, row in filtered_rules.iterrows():
        spt = format_value(row["support"])
        lift1 = format_value(row["lift"])
        itemsets_str = row["itemsets"]
        conf = format_value(row["confidence"])

        html_output += f"<tr><td>{spt}</td><td>{lift1}</td><td>{conf}</td><td>{itemsets_str}</td></tr>"

    html_output += "</table>"
    html_output += f"<br><br><div id='btns'><button class='btn btn-primary' type='button' onclick='generate({shop_id})'>Generate Bundling Recommendation</button></div>"

    return html_output.encode("utf-8")  # Encode to byte string if needed


def delBundleHistory(shop_id):
    try:
        # Establish a database connection
        conn = mysql.connector.connect(**db_config)
        cursor = conn.cursor(
            dictionary=True
        )  # Use dictionary cursor to access by column name

        # Select bundle IDs associated with the shop_id
        cursor.execute("SELECT bundle_id FROM bundles WHERE shop_id = %s", (shop_id,))
        bundles_result = cursor.fetchall()

        # Delete corresponding entries in bundleitems table
        for bundle in bundles_result:
            cursor.execute(
                "DELETE FROM bundleitems WHERE bundle_id = %s", (bundle["bundle_id"],)
            )
            conn.commit()

        # Delete entries in bundles table
        del_query = "DELETE FROM bundles WHERE shop_id = %s;"
        cursor.execute(del_query, (shop_id,))
        conn.commit()

    except mysql.connector.Error as err:
        print(f"Error: {err}")


if len(sys.argv) > 1:
    values_from_php = sys.argv[1]
    values = values_from_php.split(",")
    support, start_date, end_date, shop_id = values
    support = float(support)

    # delBundleHistory(shop_id)

    conn = mysql.connector.connect(**db_config)
    cur = conn.cursor()
    sql = "SELECT * FROM orders_report WHERE tgl_payment BETWEEN %s AND %s AND shop_id = %s"
    start_date = start_date.strip()
    end_date = end_date.strip()
    cur.execute(sql, (start_date, end_date, shop_id))
    rows = cur.fetchall()

    if len(rows) == 0:
        print('<h3 style="color:red">No data found</h3>')
    else:
        df = pd.DataFrame(rows)
        df.columns = [
            "order_id",
            "invoice",
            "nama_produk",
            "quantity",
            "tgl_payment",
            "gross_revenue",
            "shop_id",
        ]

        selected_columns = ["invoice", "nama_produk"]
        combined_data = df[selected_columns]

        grouped_df = (
            combined_data.groupby("invoice")["nama_produk"].apply(list).reset_index()
        )

        grouped_df.columns = ["invoice", "nama_produk"]

        dataset = grouped_df.values.tolist()
        dataset_without_invoice = grouped_df["nama_produk"].values.tolist()

        te = TransactionEncoder()
        te_ary = te.fit(dataset_without_invoice).transform(dataset_without_invoice)
        df_encoded = pd.DataFrame(te_ary, columns=te.columns_)

        frequent_itemsets = fpgrowth(df_encoded, min_support=support, use_colnames=True)
        rules = association_rules(frequent_itemsets, metric="lift", min_threshold=0)

        # Filter the rules based on support, lift, and confidence
        filtered_rules = rules[
            (rules["support"] >= support)
            & (rules["lift"] >= 0)
            & (rules["confidence"] >= 0)  # Set your desired confidence threshold
        ]

        # Create the itemsets column
        filtered_rules["itemsets"] = (
            filtered_rules["antecedents"].apply(lambda x: " || ".join(list(x)))
            + " => "
            + filtered_rules["consequents"].apply(lambda x: " || ".join(list(x)))
        )

        print(generate_html_table(filtered_rules, shop_id))

    cur.close()
    conn.close()
