import hashlib
import io
import json
import os
import re
import traceback
import logging
from flask import Flask, render_template, request, redirect, url_for, session, jsonify
from flask_mysqldb import MySQL
import MySQLdb.cursors
import subprocess
import datetime
from datetime import datetime
import random
import uuid
import sys
from waitress import serve

app = Flask(__name__)
logging.basicConfig(level=logging.INFO) 

app.secret_key = 'your secret key'
app.config['SESSION_COOKIE_NAME'] = 'session_app2'
# # MySQL configurations
# app.config['MYSQL_HOST'] = '34.172.107.253'
# app.config['MYSQL_USER'] = 'melissa'
# app.config['MYSQL_PASSWORD'] = '1234'
# app.config['MYSQL_DB'] = 'dataAnalytics'


# MySQL configurations
app.config['MYSQL_HOST'] = 'localhost'  # Cloud SQL Proxy's IP address
app.config['MYSQL_PORT'] = 3306 
app.config['MYSQL_USER'] = 'melissa'
app.config['MYSQL_PASSWORD'] = '1234'
app.config['MYSQL_DB'] = 'dataAnalytics'

# # MySQL configurations
# app.config['MYSQL_HOST'] = 'localhost'  # Cloud SQL Proxy's IP address
# app.config['MYSQL_USER'] = 'root'
# app.config['MYSQL_PASSWORD'] = ''
# app.config['MYSQL_DB'] = 'webApp'

# Initialize MySQL
mysql = MySQL(app)



# MySQL configurations
# app.config['MYSQL_HOST'] = 'localhost'
# app.config['MYSQL_USER'] = 'root'
# app.config['MYSQL_PASSWORD'] = ''
# app.config['MYSQL_DB'] = 'webApp'

# Define the upload directory
UPLOAD_FOLDER = r'D:\\xampp\\htdocs\\migrate2\\app\\uploads\\'
app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER

sys.stdout = io.TextIOWrapper(sys.stdout.buffer, encoding='utf-8')
# Set up logging
logging.basicConfig(level=logging.DEBUG)

# Function to hash a password using SHA-256
def hash_password(password):
    return hashlib.sha256(password.encode()).hexdigest()

# Define handler functions
@app.route('/', methods=['GET', 'POST'])
def login():
    msg = ''
    if request.method == 'POST' and 'email' in request.form and 'password' in request.form:
        email = request.form['email']
        password = request.form['password']
        
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('SELECT * FROM users WHERE user_email = %s', (email,))
        account = cursor.fetchone()
        
        if account:
            hashed_password = account['user_pass']  # Get hashed password from database
            password_hash = hashlib.sha256(password.encode()).hexdigest()  # Hash the provided password
            
            if hashed_password == password_hash:  # Compare hashed passwords
                session['loggedin'] = True
                session['id'] = account['account_id']
                session['username'] = account['account_name']
                return redirect(url_for('dashboard'))
            else:
                msg = 'Incorrect password!'
        else:
            msg = 'Email not found!'
    
    return render_template('login.html', msg=msg)

def register():
    msg = ''
    try:
        if request.method == 'POST':
            if 'email' in request.form and 'account_name' in request.form and 'password' in request.form:
                username = request.form['account_name']
                password = request.form['password']
                email = request.form['email']
                cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
                cursor.execute('SELECT * FROM users WHERE user_email = %s', (email,))
                account = cursor.fetchone()
                if account:
                    msg = 'Account already exists!'
                elif not re.match(r'[^@]+@[^@]+\.[^@]+', email):
                    msg = 'Invalid email address!'
                elif not re.match(r'[A-Za-z0-9]+', username):
                    msg = 'Username must contain only characters and numbers!'
                elif not username or not password or not email:
                    msg = 'Please fill out the form!'
                else:
                    hashed_password = hash_password(password)
                    cursor.execute('INSERT INTO users (user_email, account_name, user_pass) VALUES (%s, %s, %s)', (email, username, hashed_password))
                    mysql.connection.commit()
                    msg = 'You have successfully registered!'
                    return render_template('login.html')
            else:
                msg = 'Please fill out the form!'
    except Exception as e:
        logging.error("Exception occurred: %s", e)
        logging.error(traceback.format_exc())
        msg = 'An error occurred during registration. Please try again.'

    return render_template('register.html', msg=msg)

def forgetPass():
    msg = ''
    try:
        if request.method == 'POST':
            logging.debug("Form Data: %s", request.form)
            if 'userEmail' in request.form and 'newPass' in request.form:
                userEmail = request.form['userEmail']
                newpassword = request.form['newPass']
                cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
                cursor.execute('SELECT * FROM users WHERE user_email = %s', (userEmail,))
                account = cursor.fetchone()
                if not re.match(r'[^@]+@[^@]+\.[^@]+', userEmail):
                    msg = 'Invalid email address!'
                elif not userEmail or not newpassword:
                    msg = 'Please fill out the form!'
                else:
                    hashed_password = hash_password(newpassword)
                    cursor.execute('UPDATE users SET user_pass = %s WHERE user_email = %s', (hashed_password, userEmail))
                    mysql.connection.commit()
                    msg = 'Password changed successfully!'
                    return render_template('login.html', msg=msg)
            else:
                msg = 'Please fill out the form!'
    except Exception as e:
        logging.error("Exception occurred: %s", e)
        logging.error(traceback.format_exc())
        msg = 'An error occurred during password reset. Please try again.'

    return render_template('login.html', msg=msg)

def callShop():
    if 'id' not in session:
        return redirect(url_for('login'))

    userId = session.get('id')
    cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
    cursor.execute('SELECT shop_name, shop_id FROM shop WHERE user_id = %s', (userId,))
    shops = cursor.fetchall()

    if len(shops) == 0:
        msg = "NO SHOP REGISTERED ! ADD NEW SHOP !"
        return jsonify({'message': msg}), 200  # Return JSON response with message
    else:
        return jsonify(shops), 200  # Return JSON response with shop data

def addShop():
    if 'id' not in session:
        return redirect(url_for('login'))

    userId = session.get('id')
    if request.method == 'POST' and 'shop_name' in request.form and 'marketplace' in request.form:
        shopName = request.form['shop_name'].upper()
        marketplace = request.form['marketplace']
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('SELECT * FROM shop WHERE shop_name = %s AND user_id = %s', (shopName, userId))
        shop = cursor.fetchone()
        if shop:
            msg = 'Shop name under this account already exists!'
        elif not shopName or not marketplace :
            msg = 'Please fill out the form!'
        else:
            cursor.execute('INSERT INTO shop (shop_name, marketplace, user_id) VALUES (%s, %s, %s)', (shopName, marketplace, userId))
            mysql.connection.commit()
            msg = 'You have successfully added a new shop !'
            return render_template('user.html', msg=msg)   

def delShop():
    if 'id' not in session:
        return redirect(url_for('login'))

    tableName = ['bundles', 'orders_report', 'shop_report', 'files_log', 'shop']
    if request.method == 'POST' and 'shop_id' in request.form:
        shopId = request.form['shop_id']
        for table in tableName:
            cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
            cursor.execute(f"SELECT * FROM {table} WHERE shop_id = %s", (shopId,))
            account = cursor.fetchone()
            if account and table == "bundles":
                cursor.execute(f"SELECT bundle_id FROM {table} WHERE shop_id = %s", (shopId,))
                bundles_result = cursor.fetchall()
                for bundle in bundles_result:
                    cursor.execute(f"DELETE FROM bundleitems WHERE bundle_id = %s", (bundle['bundle_id'],))
                    mysql.connection.commit()
            elif account:
                cursor.execute(f"DELETE FROM {table} WHERE shop_id = %s", (shopId,))
                mysql.connection.commit()
        return '', 204  # Return a no content response to indicate success

    return '', 400  # Return a bad request response if shop_id is missing or invalid

def checkFiles():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if 'shop_id' in request.form:
        shop_id = request.form['shop_id']
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('SELECT COUNT(*) AS num_files FROM files_log WHERE shop_id = %s', (shop_id,))
        result = cursor.fetchone()
        if result['num_files'] == 0:
            return jsonify({'message': 'No files found for this shop.'}), 200
        else:
            return jsonify({'message': 'Files found for this shop.', 'files': result['num_files']}), 200

def loadLog():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    shop_id = request.form['shop_id']
    cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
    cursor.execute('SELECT * FROM files_log WHERE shop_id = %s', (shop_id,))
    files = cursor.fetchall()
    if len(files) == 0:
        return jsonify({'message': 'No files found for this shop.'}), 200
    else:
        return jsonify({'message': 'Files found for this shop.', 'files': files}), 200

import logging
import subprocess

def upload():
    files = request.files.getlist('xlsx_file')
    logging.info(files)
    messages = []
    
    type_file = request.form['file_type']
    shop_id = request.form['shopName']
    
    for file in files:
        if file.filename == '':
            messages.append('No selected file')
            continue
        
        current_datetime = datetime.now().strftime('%d-%m-%y-%H-%M')
        filename, file_extension = os.path.splitext(file.filename)
        new_filename = f"{type_file}_{current_datetime}{file_extension}"
        file_path = os.path.join(app.config['UPLOAD_FOLDER'], new_filename)
        logging.info(file_path)
        file.save(file_path)

        values_string = ','.join([file.filename, new_filename, type_file, shop_id])

        python_script_path = r"D:\xampp\htdocs\migrate2\app\upload.py"
        py_exec = r"C:\\Users\\liman\\AppData\\Local\\Programs\\Python\\Python311\\python.exe"
        
        command = f'"{py_exec}" "{python_script_path}" "{values_string}"'
        subprocess.run(command, shell=True)
        logging.info("run py")
    
    final_message = ' | '.join(messages)
    return render_template('files.html', xxx=final_message)


def generateMBA():
    if request.method == 'POST':
        support = request.form['support']
        start_date = request.form['dates']
        end_date = request.form['dates2']
        shop_id = request.form['shopName']

        try:
            # Convert date strings to datetime objects
            start_timestamp = datetime.strptime(start_date, '%Y-%m-%d')
            end_timestamp = datetime.strptime(end_date, '%Y-%m-%d')

            # Check if start date is greater than or equal to end date
            if start_timestamp >= end_timestamp:
                return render_template('mba.html', msg="Error: Start date must be before end date.")

        except ValueError:
            return render_template('mba.html', msg="Error: Invalid date format. Please use YYYY-MM-DD.")

        # Concatenate values into a single string separated by a delimiter
        values_string = ','.join([support, start_date, end_date, shop_id])

        python_script_path = r"D:\\xampp\\htdocs\\migrate2\\app\\sqlQuery.py"
        py_exec = r"C:\\Users\\liman\\AppData\\Local\\Programs\\Python\\Python311\\python.exe"
        command = [py_exec, python_script_path, values_string]

        try:
            output = subprocess.check_output(command, stderr=subprocess.STDOUT, text=True)
            return render_template('mba.html', msg=output.strip())
        except subprocess.CalledProcessError as e:
            return render_template('mba.html', msg=f"Error executing script: {e.output}")

    return render_template('mba.html')
    
    
def insertBundle(shop_id, data):
    try:
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        
        for row in data:
            print(row)
            # Generate new bundle_id for every row
            new_bundle = """
            INSERT INTO bundles (bundles_name, shop_id) 
            VALUES (%s, %s);
            """

            num = random.randint(1, 100)
            current_datetime = datetime.now()
            stringRand = f"bundle-{num}-{current_datetime.strftime('%Y%m%d%H%M%S')}"

            cursor.execute(new_bundle, (stringRand, shop_id))
            bundle_id = cursor.lastrowid

            itemsets = row["Set Produk"]
            antecedent, consequent = itemsets.split(" => ")

            support = row["Support"]
            lift = row["Lift"]
            confidence = row["Confidence"]

            insertItem(
                cursor,
                bundle_id,
                antecedent,
                consequent,
                support,
                confidence,
                lift,
            )

        # Commit changes to the database
        mysql.connection.commit()

        return True  # Indicate success
    except mysql.connection.Error as err:
        print(f"Error: {err}")
        return False  # Indicate failure

    finally:
        # Close cursor
        cursor.close()
            

def insertItem(cursor, bundle_id, antecedent, consequent, support, confidence, lift):
    try:
        insert_query = """
        INSERT INTO bundleitems (bundle_id, antecedent, consequent, support, confidence, lift)
        VALUES (%s, %s, %s, %s, %s, %s)
        """
        cursor.execute(
            insert_query, (bundle_id, antecedent, consequent, support, confidence, lift)
        )
    except mysql.connection.Error as err:
        print(f"Error inserting item: {err}")
            
    
        
def handleBundling():
    data = request.form['jsonData']
    shop_id = request.form['shop_id']
    bundle_items = json.loads(data) # Assuming bundle items directly in the JSON data

    if not shop_id or not bundle_items:
        return jsonify({'error': 'Missing shop_id or bundle_items'}), 400

    success = insertBundle(shop_id, bundle_items)
    if success:
        return jsonify({'message': 'Bundle inserted successfully'})
    else:
        return jsonify({'error': 'Failed to insert bundle'}), 500


def callFilteredBundlings():
    # Check if user is logged in (assuming you have session handling logic)
    if 'id' not in session:
        return redirect(url_for('login'))
    
    # Get the shop_id from the POST request
    shop_id = request.form['shop_id']
    
    # Call the print_sets function to generate HTML content
    sql = """
    SELECT id, antecedent, consequent, support, confidence, lift, date_created
    FROM bundleitems
    JOIN bundles ON bundleitems.bundle_id = bundles.bundle_id
    WHERE bundles.shop_id = %s ORDER BY bundleitems.bundle_id DESC
    """
    cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
    cursor.execute(sql, (shop_id,))
    rows = cursor.fetchall()
    
    html_out = f"<div style='height: 350px; overflow-y: scroll;'><table class='table table-striped'><tr><th>Itemsets</th><th>Support</th><th>Confidence</th><th>Lift</th><th>Created At</th><th>Detail</th></tr>"

    for row in rows:
        html_out += f"<tr><td>{row['antecedent']} => {row['consequent']}</td><td>{row['support']}</td><td>{row['confidence']}</td><td>{row['lift']}</td><td>{row['date_created']}</td><td><button class='btn btn-primary' type='button' onclick='getDetail({row['id']})'>Detail</button></td></tr>"
            
    html_out += "</table></div>"
    # Return the HTML content as a response
    return html_out.strip()       

def bundlingDetail():
     if request.method == "POST":
        bundle_id = request.form['bundle_id']
        shop_id = request.form['shop_id']

        # Concatenate values into a single string separated by a delimiter
        values_string = ','.join([bundle_id, shop_id])

        python_script_path = r"D:\\xampp\\htdocs\\migrate2\\app\\scraping.py"
        py_exec = r"C:\\Users\\liman\\AppData\\Local\\Programs\\Python\\Python311\\python.exe"

        # Construct the command to execute
        command = f'"{py_exec}" "{python_script_path}" "{values_string}"'
        try:
            # Execute the command and capture the output
            output = subprocess.check_output(command, shell=True, text=True)
            return output.strip()
        except subprocess.CalledProcessError as e:
            return f"Error executing script: {e.output}"

def callscraperesult():
    if request.method == 'POST' and 'bundle_id' in request.form and 'shop_id' in request.form:
        bundle_id = request.form['bundle_id']
        shop_id = request.form['shop_id']
        return outputTable(bundle_id, shop_id)
    else:
        return jsonify({'message': 'error'})

def outputTable(bundle_id, shop_id):
    try:
        cur = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        
        # Fetch data for the specified product from the database
        sql = "SELECT * FROM scraperesult WHERE bundle_id = %s AND shop_id = %s"
        cur.execute(sql, (bundle_id, shop_id))
        rows = cur.fetchall()
        if len(rows) > 0:
            html_string = '''
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Gambar</th>
                            <th>Nama Produk</th>
                            <th>Harga</th>
                            <th>Rating</th>
                            <th>Terjual</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
            '''

            for row in rows:
                html_string += f'''
                    <tr>
                        <td><img src="{row['href_pic']}" alt="Product Image"></td>
                        <td><a href="{row['prd_link']}">{row['prd_name']}</a></td>
                        <td>{row['price']}</td>
                        <td>{row['rating']}</td>
                        <td>{row['sold']}</td>
                        <td><input type='radio' onclick='bindSet(event)' class='options' id='{row['identifier']}' name='{row['identifier']}' value='{row['price']}'></td>
                    </tr>
                '''

            html_string += '''
                    </tbody>
                </table><br><br>
            '''
            
            return html_string.strip()
        else:
            return jsonify({'message: no data'})
    except Exception as e:
        print(f"Error: {e}")
        return jsonify({'message': 'error'})

def saveBundlingSets():
    if 'id' not in session:
        return redirect(url_for('login'))

    if request.method == 'POST':
        data = request.form.get('products')
        products = json.loads(data)
        group_id = uuid.uuid4().hex[:6]

        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        
        for product in products:
            sql = '''
            INSERT INTO savedbundlings (product_name, normal_subtotal, discount, discounted_price, quantity, unitPrice, items_id, shop_id, group_id)
            VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s)
            '''
            cursor.execute(sql, (
                product['product_name'],
                product['normal_subtotal'],
                product['discount'],
                product['discounted_price'],
                product['quantity'],
                product['unitPrice'],
                product['items_id'],
                product['shop_id'],
                group_id
            ))
        
        mysql.connection.commit()
        cursor.close()

        return jsonify({'status': 'success', 'message': 'Products saved successfully'})
        
def callSavedBundling():
    if 'id' not in session:
        return redirect(url_for('login'))

    if request.method == 'POST':
        shop_id = request.form['shop_id']
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('SELECT * FROM savedbundlings WHERE shop_id = %s', (shop_id))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data bundlings found for this shop.', 'response': results})

def updateSavedBundling():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == 'POST':
        data = request.form.get('products')
        products = json.loads(data)

        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        
        for product in products:
            sql = '''
            UPDATE savedbundlings
            SET 
                discount = %s,
                discounted_price = %s,
                quantity = %s
            WHERE itemset_id = %s
            '''

            cursor.execute(sql, (
                product['discount'],
                product['discounted_price'],
                product['quantity'],
                product['itemset_id'],
            ))
        
        mysql.connection.commit()
        cursor.close()

        return jsonify({'status': 'success', 'message': 'Products updated successfully'})
            

def delSaved():
    if 'id' not in session:
        return redirect(url_for('login'))

    if request.method == 'POST':
        group_id = request.form['group_id']
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('DELETE FROM savedbundlings WHERE group_id = %s', (group_id,))
        mysql.connection.commit()
        cursor.close()
        return jsonify({'status': 'success', 'message': 'Itemset deleted successfully'})

def callBuyersDataMonthly():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == "POST":
        shop_id = request.form['shop_id']
        month_periode = request.form['month']
        year_periode = request.form['year']
        # logging.info(shop_id, month_periode, year_periode)
        
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('SELECT city_name, buyers_count, orders_count, products_sold, total_revenue FROM buyers WHERE shop_id = %s AND month = %s AND year = %s', (shop_id, month_periode, year_periode))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data found for this shop.', 'response': results})
        else:
            return redirect(url_for('dashboard'))

def callBuyersDataYearly():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == "POST":
        shop_id = request.form['shop_id']
        year_periode = request.form['year']
        # logging.info(shop_id, month_periode, year_periode)
        
        sql = '''
        SELECT 
            city_name, 
            SUM(buyers_count) AS total_buyers,
            SUM(orders_count) AS total_orders,
            SUM(products_sold) AS total_products_sold,
            SUM(total_revenue) AS total_revenue
        FROM 
            buyers
        WHERE 
            shop_id = %s 
            AND year = %s
        GROUP BY 
            city_name;
        '''
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute(sql, (shop_id, year_periode))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data found for this shop.', 'response': results})
        else:
            return redirect(url_for('dashboard'))
    
def callSalesDataMonthly():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == "POST":
        shop_id = request.form['shop_id']
        month_periode = request.form['month']
        year_periode = request.form['year']
        # logging.info(shop_id, month_periode, year_periode)
        
        sql = '''
        SELECT 
            DAY(tgl_payment) AS day_of_month, 
            MONTH(tgl_payment) AS month, 
            SUM(gross_revenue) AS total_gross_revenue
        FROM 
            orders_report 
        WHERE 
            shop_id = %s
            AND MONTH(tgl_payment) = %s 
            AND YEAR(tgl_payment) = %s
        GROUP BY 
            DAY(tgl_payment), MONTH(tgl_payment);
        '''
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute(sql, (shop_id, month_periode, year_periode))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data found for this shop.', 'response': results})
        else:
            return redirect(url_for('dashboard'))

def callSalesDataYearly():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == "POST":
        shop_id = request.form['shop_id']
        year_periode = request.form['year']
        # logging.info(shop_id, month_periode, year_periode)
        
        sql = '''
        SELECT 
            MONTH(tgl_payment) AS month, 
            SUM(gross_revenue) AS total_gross_revenue
        FROM 
            orders_report 
        WHERE 
            shop_id = %s
            AND YEAR(tgl_payment) = %s
        GROUP BY 
            MONTH(tgl_payment)
        ORDER BY 
            MONTH(tgl_payment);
        '''
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute(sql, (shop_id, year_periode))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data found for this shop.', 'response': results})
        else:
            return redirect(url_for('dashboard'))
    

def callProductsMonthly():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == "POST":
        shop_id = request.form['shop_id']
        month_periode = request.form['month']
        year_periode = request.form['year']
        # logging.info(shop_id, month_periode, year_periode)
        
        sql = '''
        SELECT 
            nama_produk, 
            SUM(quantity) AS total_quantity_sold
        FROM 
            orders_report
        WHERE 
            shop_id = %s
            AND YEAR(tgl_payment) = %s
            AND MONTH(tgl_payment) = %s
        GROUP BY 
            nama_produk
        ORDER BY total_quantity_sold DESC;
        '''
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute(sql, (shop_id, year_periode, month_periode))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data found for this shop.', 'response': results})
        else:
            return redirect(url_for('dashboard'))   
        
def callProductsYearly():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    if request.method == "POST":
        shop_id = request.form['shop_id']
        year_periode = request.form['year']
        # logging.info(shop_id, month_periode, year_periode)
        
        sql = '''
        SELECT 
            nama_produk, 
            SUM(quantity) AS total_quantity_sold
        FROM 
            orders_report
        WHERE 
            shop_id = %s
            AND YEAR(tgl_payment) = %s
        GROUP BY 
            nama_produk
        ORDER BY total_quantity_sold DESC;
        '''
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute(sql, (shop_id, year_periode))
        results = cursor.fetchall()
        if len(results) != 0:
            return jsonify({'message': 'Data found for this shop.', 'response': results})
        else:
            return redirect(url_for('dashboard'))  

def userData():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    userId = session.get('id')
    cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
    cursor.execute('SELECT account_name, user_email FROM users WHERE account_id = %s', (userId,))
    result = cursor.fetchone()
    
    if result:
        return jsonify({'result': result}), 200
    else:
        return jsonify({'error': 'User data not found'}), 404

def updateProfile():
    if 'id' not in session:
        return redirect(url_for('login'))
    
    userId = session.get('id')
    if request.method == "POST" and 'usrname' in request.form and 'emailUsr' in request.form and 'passUsr' in request.form :
        usrname = request.form['usrname']
        emailUsr = request.form['emailUsr']
        passUsr = request.form['passUsr']
        hashed_pass = hash_password(passUsr)
        cursor = mysql.connection.cursor(MySQLdb.cursors.DictCursor)
        cursor.execute('SELECT COUNT(*) FROM users WHERE user_email = %s AND account_id != %s', ((usrname, emailUsr)))
        if cursor.fetchone() != None:
           return render_template('user.html', upd="Email already exists")
        else:
            cursor.execute('UPDATE users SET account_name = %s, user_email = %s, user_pass = %s WHERE account_id = %s',
                    (usrname, emailUsr, hashed_pass, userId))
            # Commit changes to the database
            mysql.connection.commit()
            return render_template('user.html', upd="User data updated successfully")
        
        
def logout():
    session.pop('loggedin', None)
    session.pop('id', None)
    session.pop('username', None)
    return redirect(url_for('login'))

def generic_template_renderer(template_name):
    return render_template(template_name)

# Define routes and their respective handler functions
routes = [
    {'endpoint': 'login', 'route': '/login', 'methods': ['GET', 'POST'], 'handler': login},
    {'endpoint': 'register', 'route': '/register', 'methods': ['GET', 'POST'], 'handler': register},
    {'endpoint': 'forgetPass', 'route': '/forgetPass', 'methods': ['GET', 'POST'], 'handler': forgetPass},
    {'endpoint': 'userData', 'route': '/userData', 'methods': ['GET'], 'handler': userData},
    {'endpoint': 'updateProfile', 'route': '/updateProfile', 'methods': ['POST'], 'handler': updateProfile},
    {'endpoint': 'callShop', 'route': '/callShop', 'methods': ['GET'], 'handler': callShop},
    {'endpoint': 'callFilteredBundlings', 'route': '/callFilteredBundlings', 'methods': ['POST'], 'handler': callFilteredBundlings},
    {'endpoint': 'callBuyersDataMonthly', 'route': '/callBuyersDataMonthly', 'methods': ['POST'], 'handler': callBuyersDataMonthly},
    {'endpoint': 'callBuyersDataYearly', 'route': '/callBuyersDataYearly', 'methods': ['POST'], 'handler': callBuyersDataYearly},
    {'endpoint': 'callSalesDataMonthly', 'route': '/callSalesDataMonthly', 'methods': ['POST'], 'handler': callSalesDataMonthly},
    {'endpoint': 'callSalesDataYearly', 'route': '/callSalesDataYearly', 'methods': ['POST'], 'handler': callSalesDataYearly},
    {'endpoint': 'callProductsMonthly', 'route': '/callProductsMonthly', 'methods': ['POST'], 'handler': callProductsMonthly},
        {'endpoint': 'callProductsYearly', 'route': '/callProductsYearly', 'methods': ['POST'], 'handler': callProductsYearly},
    {'endpoint': 'callscraperesult', 'route': '/callscraperesult', 'methods': ['POST'], 'handler': callscraperesult},
    {'endpoint': 'addShop', 'route': '/addShop', 'methods': ['GET','POST'], 'handler': addShop},
    {'endpoint': 'delShop', 'route': '/delShop', 'methods': ['POST'], 'handler': delShop},
    {'endpoint': 'saveBundlingSets', 'route': '/saveBundlingSets', 'methods': ['POST'], 'handler': saveBundlingSets},
    {'endpoint': 'callSavedBundling', 'route': '/callSavedBundling', 'methods': ['POST'], 'handler': callSavedBundling},
    {'endpoint': 'updateSavedBundling', 'route': '/updateSavedBundling', 'methods': ['POST'], 'handler': updateSavedBundling},
    {'endpoint': 'delSaved', 'route': '/delSaved', 'methods': ['POST'], 'handler': delSaved},
    {'endpoint': 'checkFiles', 'route': '/checkFiles', 'methods': ['POST'], 'handler': checkFiles},
    {'endpoint': 'loadLog', 'route': '/loadLog', 'methods': ['POST'], 'handler': loadLog},
    {'endpoint': 'upload', 'route': '/upload', 'methods': ['POST'], 'handler': upload},
    {'endpoint': 'generateMBA', 'route': '/generateMBA', 'methods': ['GET','POST'], 'handler': generateMBA},
    {'endpoint': 'handleBundling', 'route': '/handleBundling', 'methods': ['POST'], 'handler': handleBundling},
    {'endpoint': 'bundlingDetail', 'route': '/bundlingDetail', 'methods': ['POST'], 'handler': bundlingDetail},
    {'endpoint': 'logout', 'route': '/logout', 'methods': ['GET'], 'handler': logout},
    {'endpoint': 'buyerInsight', 'route': '/buyerInsight', 'methods': ['GET'], 'template': 'buyerInsight.html'},
    {'endpoint': 'user', 'route': '/user', 'methods': ['GET'], 'template': 'user.html'},
    {'endpoint': 'mba', 'route': '/mba', 'methods': ['GET'], 'template': 'mba.html'},
    {'endpoint': 'files', 'route': '/files', 'methods': ['GET'], 'template': 'files.html'},
    {'endpoint': 'bundlings', 'route': '/bundlings', 'methods': ['GET'], 'template': 'bundlings.html'},
    {'endpoint': 'dashboard', 'route': '/dashboard', 'methods': ['GET'], 'template': 'dashboard.html'},
    {'endpoint': 'bundlingMenu', 'route': '/bundlingMenu', 'methods': ['GET'], 'template': 'bundlingMenu.html'},
]

# Add routes dynamically
for route in routes:
    if 'handler' in route:
        app.add_url_rule(route['route'], endpoint=route['endpoint'], view_func=route['handler'], methods=route['methods'])
    elif 'template' in route:
        app.add_url_rule(route['route'], endpoint=route['endpoint'], view_func=lambda template_name=route['template']: generic_template_renderer(template_name), methods=route['methods'])

if __name__ == "__main__":
    app.run(debug=True)
