#!C:\Users\liman\AppData\Local\Programs\Python\Python311\python.exe
# print("Content-Type: text/html\n")

import os
import logging
import mysql.connector
import pandas as pd
import sys
import subprocess
from datetime import datetime


def process_orders_data(filename):
    # Read the Excel file into a DataFrame
    combined_data = pd.read_excel(filename, sheet_name=1, header=6)
    df = pd.DataFrame(combined_data)
    columns = [
        "Nomor Invoice",
        "Nama Produk",
        "Tanggal Pembayaran",
        "Status Terakhir",
        "Jumlah Produk Dibeli",
        "Harga Jual (IDR)",
    ]
    df2 = df[columns]
    # Filter out rows where 'Status Terakhir' contains the word 'dibatalkan'
    df_filtered = df2[
        ~df2["Status Terakhir"].str.contains("dibatalkan", case=False, na=False)
    ]

    df_filtered = df_filtered.copy()

    # Convert 'Tanggal Pembayaran' to datetime format
    df_filtered["Tanggal Pembayaran"] = pd.to_datetime(
        df_filtered["Tanggal Pembayaran"], format="%d-%m-%Y %H:%M:%S", errors="coerce"
    )

    if df_filtered["Tanggal Pembayaran"].isnull().any():
        print("Conversion failed for some entries in 'Tanggal Pembayaran'.")

    # Reformat the 'Tanggal Pembayaran' to the desired string format
    df_filtered["Tanggal Pembayaran"] = df_filtered["Tanggal Pembayaran"].dt.strftime(
        "%Y-%m-%d %H:%M:%S"
    )

    # Drop duplicate rows
    df_filtered = df_filtered.drop_duplicates()

    return df_filtered


def upload_orders_data(df, shop_id, db_config):
    conn = mysql.connector.connect(**db_config)
    cursor = conn.cursor()

    insert_query = """
    INSERT INTO orders_report (invoice, nama_produk, tgl_payment, quantity, gross_revenue, shop_id)
    VALUES (%s, %s, %s, %s, %s, %s)
    """
    try:
        for index, row in df.iterrows():
            cursor.execute(
                insert_query,
                (
                    row["Nomor Invoice"],
                    row["Nama Produk"],
                    row["Tanggal Pembayaran"],
                    row["Jumlah Produk Dibeli"],
                    row["Harga Jual (IDR)"],
                    shop_id,
                ),
            )

        conn.commit()
        print("Data inserted successfully.")

    except Exception as e:
        print(f"Error occurred: {e}")
        conn.rollback()  # Rollback changes in case of error

    finally:
        cursor.close()
        conn.close()


def process_sales_data(filename):
    combined_data = pd.read_excel(filename, sheet_name=1, header=6)
    df = pd.DataFrame(combined_data)

    df = df.drop(columns=["Total", "No"])

    melted_df = df.melt(
        id_vars=["Nama Produk"], var_name="Date", value_name="Number Sold"
    )

    melted_df = melted_df[melted_df["Number Sold"] > 0].reset_index(drop=True)

    melted_df["Date"] = pd.to_datetime(
        melted_df["Date"], format="%d %b %Y", errors="coerce"
    )

    if melted_df["Date"].isnull().any():
        print("Conversion failed for some entries in 'Date'.")

    melted_df["Date"] = melted_df["Date"].dt.strftime("%Y-%m-%d")

    return melted_df


def upload_sales_data(df, shop_id, db_config):
    conn = mysql.connector.connect(**db_config)
    cursor = conn.cursor()

    insert_query = """
    INSERT INTO shop_report (nama_produk, tgl_terjual, qty, shop_id)
    VALUES (%s, %s, %s, %s)
    """

    for index, row in df.iterrows():
        cursor.execute(
            insert_query, (row["Nama Produk"], row["Date"], row["Number Sold"], shop_id)
        )

    conn.commit()
    cursor.close()
    conn.close()


def upload_buyers_data(filename, shop_id, db_config):
    df = pd.read_excel(filename, engine="openpyxl")
    date_range = df.iloc[
        1, 0
    ]  # Assuming the date range is in the first row, first column
    dates = date_range.split(" - ")
    # Convert the strings to datetime objects
    start_date_obj = datetime.strptime(dates[0], "%d/%m/%Y")
    month = start_date_obj.month
    year = start_date_obj.year

    df2 = pd.read_excel(filename, skiprows=5)
    data_columns = ["Kota", "Pembeli", "Pesanan", "Barang", "Nilai Pesanan"]
    df2 = df2[data_columns]
    df2["Nilai Pesanan"] = df2["Nilai Pesanan"].replace("[Rp,]", "", regex=True)
    conn = mysql.connector.connect(**db_config)
    cursor = conn.cursor()

    insert_query = """
    INSERT INTO buyers (city_name, buyers_count, orders_count, products_sold, total_revenue, shop_id, month, year)
    VALUES (%s, %s, %s, %s, %s, %s, %s, %s)
    """

    for index, row in df2.iterrows():
        cursor.execute(
            insert_query,
            (
                row["Kota"],
                row["Pembeli"],
                row["Pesanan"],
                row["Barang"],
                row["Nilai Pesanan"],
                shop_id,
                month,
                year,
            ),
        )

    conn.commit()
    cursor.close()
    conn.close()


def insert_log(old, new, file_type, shop_id, db_config):
    conn = mysql.connector.connect(**db_config)
    cursor = conn.cursor()

    insert_query = """
    INSERT INTO files_log (old_filename, renamed_filename, file_type, shop_id)
    VALUES (%s, %s, %s, %s)
    """

    cursor.execute(insert_query, (old, new, file_type, shop_id))

    conn.commit()
    cursor.close()
    conn.close()


db_config = {
    "host": "localhost",
    "port": 3306,
    "user": "melissa",
    "password": "1234",
    "database": "dataAnalytics",
}

# db_config = {
#     "host": "localhost",
#     "user": "root",
#     "password": "",
#     "database": "webApp",
# }
# db_config = {
#     "host": "34.172.107.253",
#     "user": "melissa",
#     "password": "1234",
#     "database": "dataAnalytics",
# }


if __name__ == "__main__":
    if len(sys.argv) > 1:
        value_from_flask = sys.argv[1]
        values = value_from_flask.split(",")

        old_file, new_name, file_type, shop_id = values

        print(values)
        file_path = os.path.join(
            r"D:\\xampp\\htdocs\\migrate2\\app\\uploads\\", new_name
        )
        print(file_path)

        try:
            if file_type == "order":
                df = process_orders_data(file_path)
                upload_orders_data(df, shop_id, db_config)
            elif file_type == "pembeli":
                upload_buyers_data(file_path, shop_id, db_config)

            insert_log(old_file, new_name, file_type, shop_id, db_config)

        except Exception as e:
            logging.error("An error occurred", exc_info=True)
            print(f"An error occurred: {e}")

        # # Return a non-zero exit code if there was an error
        # sys.exit(1)
    else:
        # Return a zero exit code if everything executed successfully
        sys.exit(0)
