import json
import os
from selenium import webdriver
from selenium.webdriver.chrome.options import Options
import time

# Set up Chrome options
options = Options()
options.add_argument("--enable-javascript")
# options.add_argument("--headless")
options.add_argument(
    "user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.6422.141 Safari/537.36"
)
options.add_argument("--window-position=-2000,0")

# Path to the ChromeDriver executable
chromedriver_path = "./chromedriver.exe"

try:
    # Add the ChromeDriver executable to the system PATH
    os.environ["PATH"] += os.pathsep + os.path.dirname(os.path.abspath(chromedriver_path))
    # Create a WebDriver instance
    driver = webdriver.Chrome(options=options)
    print("WebDriver initialized successfully.")
    
    # Add your scraping logic here
    
except Exception as e:
    print("An error occurred during WebDriver initialization:", e)
    # Add additional error handling and cleanup logic here, if needed

finally:
    # Close the WebDriver instance
    try:
        driver.quit()
        print("WebDriver quit successfully.")
    except Exception as e:
        print("An error occurred while quitting WebDriver:", e)
