<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Stock Opname</h1>
        <a href="/stock" class="btn btn-primary">Back</a>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">Stock Opname</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                            <a href="<?php echo e(route('stock_opname.edit')); ?>" class="btn btn-primary">Update Stock Opname</a>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <?php if($stock_opname->isEmpty()): ?>
                        <div class="alert alert-info" role="alert">
                            Belum Melakukan Stock Opname.
                        </div>
                    <?php else: ?>
                        <div class="row">
                            <div class="col-sm-12 table-responsive" style="max-height: 400px; overflow-y: auto;">
                                <table id="stockOpnameList" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>ID Barang</th>
                                            <th>Nama Barang</th>
                                            <th>Stock Awal</th>
                                            <th>Stock Akhir</th>
                                            <th>Selisih</th>
                                            <th>Catatan</th>
                                            <th>Tanggal Opname</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $stock_opname; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($stock->stock_id); ?></td>
                                                <td><?php echo e($stock->stock->nama_barang); ?></td>
                                                <td><?php echo e($stock->jumlah_awal); ?></td>
                                                <td><?php echo e($stock->jumlah_akhir); ?></td>
                                                <td><?php echo e($stock->selisih); ?></td>
                                                <td><?php echo e($stock->catatan); ?></td>
                                                <td><?php echo e($stock->updated_at->format('d-m-Y')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/stockOpname/index.blade.php ENDPATH**/ ?>