<?php

use App\Models\Stock;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\AbsensiController;
use App\Http\Controllers\HistoryController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\LabarugiController;
use App\Http\Controllers\RegisterController;
use App\Http\Controllers\PembelianController;
use App\Http\Controllers\PenggajianController;
use App\Http\Controllers\StockOpnameController;
use App\Http\Controllers\NeracaSaldoController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
// routes home
Route::get('/', function () {
    return view("home", [
        "title" => "Home",
        "active"=>'home'
    ]);
});

// routes login & logout
Route::get('/login',[LoginController::class,'index'])->name('login')-> middleware('guest');
Route::post('/login',[LoginController::class,'authenticate']);
Route::post('/logout',[LoginController::class,'logout']);

//routes register
Route::get('/register',[RegisterController::class,'index'])->middleware("guest");
Route::post('/register',[RegisterController::class,'store']);

// routes dashboard
Route::get('/dashboard',function(){
    return view('dashboard.index');

})->name('dashboard')->middleware('auth');

//routes services
Route::middleware(['auth'])->group(function () {
    Route::get('/service',[ServiceController::class,'index'])->name('service.index');
    Route::post('/service', [ServiceController::class, 'index'])->name('cek');
    Route::post('/service/cekNota',[ServiceController::class,'cekNota'])->name('cekNota');
    Route::post('/service/tambah',[ServiceController::class,'tambahHistory'])->name('tambahHistory');
    Route::post('/service/tambahkan/{id}',[ServiceController::class,'tambahService'])->name('tambahService');
    Route::get('/service/{id}',[ServiceController::class,'service'])->name('service');
    Route::put('/service/update/{id}',[ServiceController::class,'updateService'])->name('updateService');
    Route::delete('service/{id}', [ServiceController::class, 'deleteService'])->name('deleteService');
    Route::put('service/history/{id}',[ServiceController::class,'updateHistory'])->name('updateHistory');
});

Route::get('/get-stock/{id}', function($id) {
    $stock = Stock::find($id);
    return response()->json($stock);
});

//routes History
Route::get('/history',[HistoryController::class,'index'])->name('history.index')->middleware('auth');
Route::get('/history/print/{id}',[HistoryController::class,'print'])->name('history.print')->middleware('auth');
Route::delete('/history/delete/{id}',[HistoryController::class,'deleteHistory'])->name('deleteHistory')->middleware('auth');
Route::get('/history', [HistoryController::class, 'index'])->name('history.index');


//routes Stock
Route::get('/stock',[StockController::class,'index'])->name('stock.index')->middleware('auth');
Route::delete('stock/{stock}', [StockController::class, 'destroy'])->name('stock.destroy')->middleware('auth');
Route::post('stock', [StockController::class, 'store'])->name('stock.store')->middleware('auth');
Route::resource('stocks', StockController::class)->middleware('auth');

//routes stock opname
Route::get('/stock_opname', [StockOpnameController::class, 'index'])->name('stock_opname.index')->middleware('auth');
Route::get('/stock_opname/edit', [StockOpnameController::class, 'edit'])->name('stock_opname.edit')->middleware('auth');
Route::put('/stock_opname', [StockOpnameController::class, 'update'])->name('stock_opname.update')->middleware('auth');


//routes customers
Route::middleware(['auth'])->group(function () {
    Route::resource('customer', CustomerController::class);
    Route::post('customer', [CustomerController::class, 'store'])->name('customer.store');
    Route::delete('customer/{customer}', [CustomerController::class, 'destroy'])->name('customer.destroy');
});

//routes pembelian
Route::get('/pembelian',[PembelianController::class,'index'])->middleware('auth');
Route::delete('pembelian/{pembelian}', [PembelianController::class, 'destroy'])->name('pembelian.destroy')->middleware('auth');
Route::post('pembelian', [PembelianController::class, 'store'])->name('pembelian.store')->middleware('auth');
Route::resource('pembelian', PembelianController::class)->middleware('auth');

//routes laba rugi
// Route::get('/labarugi',[LabarugiController::class,'index']);
Route::get('/labarugi', [LabarugiController::class, 'index'])->name('laporan.laba-rugi')->middleware('auth');

//routes neraca saldo
Route::get('/neracasaldo', [NeracaSaldoController::class, 'index'])->name('laporan.neraca-saldo')->middleware('auth');
Route::post('/neracasaldo', [NeracaSaldoController::class, 'store'])->name('neraca-saldo.store')->middleware('auth');

//routes employee
Route::get('/employee',[EmployeeController::class,'index'])->middleware('auth');
Route::delete('employee/{employee}', [EmployeeController::class, 'destroy'])->name('employee.destroy')->middleware('auth');
Route::post('employee', [EmployeeController::class, 'store'])->name('employee.store')->middleware('auth');
Route::resource('employees', EmployeeController::class)->middleware('auth');

//routes absensi
Route::get('/absensi', [AbsensiController::class, 'index'])->name('absensi.index')->middleware('auth');
Route::post('/absensi/store', [AbsensiController::class, 'store'])->name('absensi.store')->middleware('auth');


//routes penggajian
Route::middleware(['auth'])->group(function () {
    Route::get('/penggajian', [PenggajianController::class, 'index'])->name('penggajian.index');
    Route::post('/penggajian/{employee}', [PenggajianController::class, 'update'])->name('penggajian.update');
});

