@extends('dashboard.layouts.main')
@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Stock</h1>
        <a href="/stock_opname" class="btn btn-primary">Stock Opname</a>
    </div>

        <form action="{{ route('stocks.index') }}" method="GET">
            <div class="input-group mb-3">
            <input type="text" class="form-control" placeholder="Search" name="search" value="{{ $search }}">
            <button class="btn btn-danger" type="submit">Search</button>
        </form>

    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">Stock List</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6" align="right">
                            <button type="button" id="addStock" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#addStockModal" class="btn btn-primary bg-gradient btn-sm rounded-1"><i
                                    class="far fa-plus-square"></i> Add Stock</button>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            @if (isset($stocks) && count($stocks) > 0)
                                <table id="stockList" class="table table-bordered table-striped">
                                    {{-- Table headers --}}
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Nama</th>
                                            <th>Jumlah</th>
                                            <th>Harga Rata - Rata</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- Table rows --}}
                                        @foreach ($stocks as $stock)
                                            <tr>
                                                <td><b>{{ $stock->id }}</b></td>
                                                <td>{{ $stock->nama_barang }}</td>
                                                <td>{{ $stock->jumlah_barang }}</td>
                                                <td>Rp. {{ number_format($stock->harga_average, 0, ',', '.') }}</td>
                                                <td>
                                                    <a class="badge bg-warning" data-bs-toggle="modal"
                                                        data-bs-target="#editStockModal{{ $stock->id }}"><i
                                                            class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                                    <form action="{{ route('stock.destroy', $stock) }}" method="post"
                                                        style="display: inline-block;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button class="badge bg-danger border-0"
                                                            onclick="return confirm('Are You Sure ?')"><i
                                                                class="bi bi-trash3"></i></button>
                                                    </form>
                                                </td>
                                            </tr>

                                            {{-- Modal for editing stock --}}
                                            <div class="modal fade" id="editStockModal{{ $stock->id }}">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="editStockModalLabel">Edit Stock</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <form method="post" action="{{ route('stocks.update', $stock) }}">
                                                                @csrf
                                                                @method('PUT')
                                                                <div class="mb-3">
                                                                    <label class="control-label">Nama Barang</label>
                                                                    <input type="text" name="nama_barang" class="form-control rounded-0"
                                                                        value="{{ $stock->nama_barang }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="control-label">Jumlah Barang</label>
                                                                    <input type="number" name="jumlah_barang" class="form-control rounded-0"
                                                                        value="{{ $stock->jumlah_barang }}" required>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-success">Update Stock</button>
                                                                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </tbody>
                                </table>
                            @else
                                <p>No stock available.</p>
                            @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    {{-- Modal untuk form tambah stock --}}
    <div class="modal fade" id="addStockModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addStockModalLabel">Tambah Stock Baru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <form method="post" action="{{ route('stocks.store') }}">
                        @csrf
                        {{-- Form stock --}}
                        <div class="mb-3">
                            <label class="control-label">Nama Barang</label>
                            <input type="text" name="nama_barang" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">Jumlah Barang</label>
                            <input type="number" name="jumlah_barang" class="form-control rounded-0" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Tambah Stock</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
