<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Stock extends Model
{
    use HasFactory;

    protected $table = 'stock';
    protected $fillable = ['nama_barang', 'jumlah_barang','harga_average'];

    public function pembelians()
    {
        return $this->hasMany(Pembelian::class, 'nama_barang', 'nama_barang');
    }
    public function stockOpname()
    {
        return $this->hasMany(Stock_Opname::class);
    }
}
