<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Pembelian</h1>
    </div>
    <form action="<?php echo e(route('pembelian.index')); ?>" method="GET">
        <div class="input-group mb-3">
            <input type="text" class="form-control" placeholder="Search" name="search" value="<?php echo e(request('search')); ?>">
            <button class="btn btn-danger" type="submit">Search</button>
        </div>
    </form>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">List Pembelian</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                            <button type="button" id="addPembelian" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#addPembelianModal"><i class="far fa-plus-square"></i> Add Pembelian</button>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="supplierList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Nama Supplier</th>
                                        <th>Nama Barang</th>
                                        <th>Jumlah</th>
                                        <th>Harga / Barang</th>
                                        <th>Total</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $pembelians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pembelian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><b><?php echo e($pembelian->id); ?></b></td>
                                            <td><?php echo e($pembelian->nama_supplier); ?></td>
                                            <td><?php echo e($pembelian->nama_barang); ?></td>
                                            <td><?php echo e($pembelian->jumlah_barang); ?></td>
                                            <td>Rp. <?php echo e(number_format($pembelian->harga_barang, 0, ',', '.')); ?></td>
                                            <td>Rp. <?php echo e(number_format($pembelian->harga_total, 0, ',', '.')); ?></td>
                                            <td>
                                                <a class="badge bg-warning" data-bs-toggle="modal" data-bs-target="#editPembelianModal<?php echo e($pembelian->id); ?>"><i class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                                <form action="<?php echo e(route('pembelian.destroy', $pembelian)); ?>" method="post" style="display: inline-block;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="badge bg-danger border-0" onclick="return confirm('Are You Sure ?')"><i class="bi bi-trash3"></i></button>
                                                </form>
                                            </td>
                                        </tr>

                                        
                                        <div class="modal fade" id="editPembelianModal<?php echo e($pembelian->id); ?>">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Edit Pembelian</h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="container-fluid">
                                                            <form method="post" action="<?php echo e(route('pembelian.update', $pembelian->id)); ?>">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('PUT'); ?>
                                                                <div class="mb-3">
                                                                    <label class="control-label">Nama Supplier</label>
                                                                    <input type="text" name="nama_supplier" class="form-control rounded-0" value="<?php echo e($pembelian->nama_supplier); ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="nama_barang" class="form-label">Nama Barang</label>
                                                                    <select class="form-select" name="nama_barang">
                                                                        <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($stock->nama_barang); ?>" <?php echo e($stock->nama_barang == $pembelian->nama_barang ? 'selected' : ''); ?>><?php echo e($stock->nama_barang); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="control-label">Jumlah Barang</label>
                                                                    <input type="number" name="jumlah_barang" class="form-control rounded-0" value="<?php echo e($pembelian->jumlah_barang); ?>" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="control-label">Harga Barang</label>
                                                                    <input type="text" name="harga_barang" class="form-control rounded-0" value="<?php echo e($pembelian->harga_barang); ?>" required>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-success">Update Pembelian</button>
                                                                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="addPembelianModal" class="modal fade">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add Pembelian</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <form method="post" action="<?php echo e(route('pembelian.store')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label class="control-label">Nama Supplier</label>
                                <input type="text" name="nama_supplier" class="form-control rounded-0" required>
                            </div>
                            <div class="mb-3">
                                <label for="nama_barang" class="form-label">Nama Barang</label>
                                <select class="form-select" name="nama_barang">
                                    <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($stock->nama_barang); ?>"><?php echo e($stock->nama_barang); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="control-label">Jumlah Barang</label>
                                <input type="number" name="jumlah_barang" class="form-control rounded-0" required>
                            </div>
                            <div class="mb-3">
                                <label class="control-label">Harga Barang</label>
                                <input type="text" name="harga_barang" class="form-control rounded-0" required>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Tambah Pembelian</button>
                                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/pembelian/index.blade.php ENDPATH**/ ?>