<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Employee</h1>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">Employee List</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6" align="right">
                            <button type="button" name="add" id="addEmployee" class="btn btn-primary"
                                data-bs-toggle="modal" data-bs-target="#addEmployeeModal">
                                <i class="far fa-plus-square"></i> New Employee
                            </button>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="employeeList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Address</th>
                                        <th>Mobile</th>
                                        <th>Jumlah kendaraan</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                    </tr>
                                    <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><b><?php echo e($employee->id); ?></b></td>
                                            <td><?php echo e($employee->nama); ?></td>
                                            <td><?php echo e($employee->alamat); ?></td>
                                            <td><?php echo e($employee->telp); ?></td>
                                            <td><?php echo e($employee->jumlah_kendaraan); ?></td>
                                            <td>
                                                <a class="badge bg-warning" data-bs-toggle="modal" data-bs-target="#editEmployeeModal<?php echo e($employee->id); ?>"><i class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                                <form action="<?php echo e(route('employee.destroy', $employee)); ?>" method="post"
                                                    style="display: inline-block;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="badge bg-danger border-0"
                                                        onclick="return confirm('Are You Sure ?')"><i
                                                            class="bi bi-trash3"></i></button>
                                            </td>
                                            </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="addEmployeeModal" tabindex="-1" aria-labelledby="addEmployeeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addEmployeeModalLabel">New Employee</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    
                    <form method="post" action="<?php echo e(route('employees.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label class="control-label">Nama</label>
                            <input type="text" name="nama" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">No Telp</label>
                            <input type="number" name="telp" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">Alamat</label>
                            <textarea name="alamat" class="form-control rounded-0" rows="5" required></textarea>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Tambah Employee</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editEmployeeModal<?php echo e($employee->id); ?>" tabindex="-1" aria-labelledby="editEmployeeModalLabel<?php echo e($employee->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editEmployeeModalLabel<?php echo e($employee->id); ?>">Edit Employee</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="post" action="<?php echo e(route('employees.update', $employee)); ?>">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="mb-3">
                        <label class="control-label">Name</label>
                        <input type="text" name="nama" class="form-control rounded-0" value="<?php echo e($employee->nama); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="control-label">No Telp</label>
                        <input type="number" name="telp" class="form-control rounded-0" value="<?php echo e($employee->telp); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="control-label">Alamat</label>
                        <textarea name="alamat" class="form-control rounded-0" rows="5" required><?php echo e($employee->alamat); ?></textarea>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Update Employee</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Files\2024\05 - Bengkel\bengkel\resources\views/employee/index.blade.php ENDPATH**/ ?>