<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Laba Rugi</h1>
    </div>

    <form action="<?php echo e(route('laporan.laba-rugi')); ?>" method="GET" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <select name="month" class="form-control">
                    <?php for($m = 1; $m <= 12; $m++): ?>
                        <option value="<?php echo e($m); ?>" <?php echo e($m == $selectedMonth ? 'selected' : ''); ?>>
                            <?php echo e(DateTime::createFromFormat('!m', $m)->format('F')); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="year" class="form-control">
                    <?php for($y = date('Y'); $y >= date('Y') - 2; $y--): ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($y == $selectedYear ? 'selected' : ''); ?>>
                            <?php echo e($y); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </div>
    </form>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    Pendapatan
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php $__currentLoopData = $pendapatan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><?php echo e($item->customer->nama); ?></span>
                                <span>Tanggal: <?php echo e($item->created_at->format('d-m-Y')); ?></span>
                                <span>Total: Rp. <?php echo e(number_format($item->harga_total, 0, ',', '.')); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-danger text-white">
                    Beban
                </div>
                <div class="card-body">
                    <h5>Pembelian</h5>
                    <ul class="list-group">
                        <?php $__currentLoopData = $pembelians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pembelian): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span><?php echo e($pembelian->nama_barang); ?></span>
                                <span>Jumlah: <?php echo e($pembelian->jumlah_barang); ?></span>
                                <span>Harga Rata-Rata : Rp.
                                    <?php echo e(number_format($pembelian->harga_average, 0, ',', '.')); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <h5>Gaji Pegawai</h5>
                    <ul class="list-group">
                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pegawai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>Nama: <?php echo e($pegawai->nama); ?></span>
                                <?php if($pegawai->gaji->isNotEmpty()): ?>
                                    <span>Gaji: Rp. <?php echo e(number_format($pegawai->gaji->first()->gaji, 0, ',', '.')); ?></span>
                                <?php else: ?>
                                    <span>Gaji: Belum ditentukan</span>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-success text-white">
                    Total Pendapatan
                </div>
                <div class="card-body">
                    <p>Rp. <?php echo e(number_format($totalPendapatan, 0, ',', '.')); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    Total Beban
                </div>
                <div class="card-body">
                    <p>Rp. <?php echo e(number_format($totalBeban, 0, ',', '.')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-info text-white">
                    Laba Bersih
                </div>
                <div class="card-body">
                    <p>Rp. <?php echo e(number_format($labaBersih, 0, ',', '.')); ?></p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/labarugi.blade.php ENDPATH**/ ?>