<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Neraca Saldo</h1>
    </div>
    <form action="<?php echo e(route('laporan.neraca-saldo')); ?>" method="GET" class="mb-4">
        <div class="row">
            <div class="col-md-3">
                <select name="month" class="form-control">
                    <?php for($m = 1; $m <= 12; $m++): ?>
                        <option value="<?php echo e($m); ?>" <?php echo e($m == request('month', $month) ? 'selected' : ''); ?>>
                            <?php echo e(DateTime::createFromFormat('!m', $m)->format('F')); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="year" class="form-control">
                    <?php for($y = date('Y'); $y >= date('Y') - 2; $y--): ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($y == request('year', $year) ? 'selected' : ''); ?>>
                            <?php echo e($y); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </div>
    </form>
    <div class="row mb-3">
        <div class="col-lg-12">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAccountModal">
                Tambah Akun
            </button>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive" style="max-height: 400px; overflow-y: auto;">
                            <table id="accountList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No Akun</th>
                                        <th>Tanggal</th>
                                        <th>Nama Akun</th>
                                        <th>Debit</th>
                                        <th>Kredit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $counter = 1;
                                    ?>

                                    <?php $__currentLoopData = $akuns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $akun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($counter++); ?></td>
                                            <td><?php echo e($akun->created_at->format('d-m-Y')); ?></td>
                                            <td><?php echo e($akun->nama_akun); ?></td>
                                            <td>Rp.
                                                <?php echo e($akun->tipe_akun == 'debit' ? number_format($akun->nominal, 0, ',', '.') : '0'); ?>

                                            </td>
                                            <td>Rp.
                                                <?php echo e($akun->tipe_akun == 'kredit' ? number_format($akun->nominal, 0, ',', '.') : '0'); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $historys): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($counter++); ?></td>
                                            <td><?php echo e($historys->created_at->format('d-m-Y')); ?></td>
                                            <td>Service <?php echo e($historys->customer->nama); ?></td>
                                            <td>Rp. <?php echo e(number_format($historys->harga_total, 0, ',', '.')); ?></td>
                                            <td>Rp. 0</td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php $__currentLoopData = $gaji; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gajis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($counter++); ?></td>
                                        <td><?php echo e($gajis->created_at->format('d-m-Y')); ?></td>
                                        <td>Gaji <?php echo e($gajis->employee->nama); ?></td>
                                        <td>Rp. 0</td>
                                        <td>Rp. <?php echo e(number_format($gajis->gaji, 0, ',', '.')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    <?php $__currentLoopData = $pembelian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pembelians): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($counter++); ?></td>
                                            <td><?php echo e($pembelians->created_at->format('d-m-Y')); ?></td>
                                            <td>Pembelian <?php echo e($pembelians->nama_barang); ?></td>
                                            <td>Rp. 0</td>
                                            <td>Rp. <?php echo e(number_format($pembelians->harga_total, 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th>Total</th>
                                        <th>Rp. <?php echo e(number_format($totalDebit, 0, ',', '.')); ?></th>
                                        <th>Rp. <?php echo e(number_format($totalKredit, 0, ',', '.')); ?></th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="addAccountModal" tabindex="-1" aria-labelledby="addAccountModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addAccountModalLabel">Tambah Akun</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?php echo e(route('neraca-saldo.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="namaAkun" class="form-label">Nama Akun</label>
                            <input type="text" class="form-control" id="namaAkun" name="nama_akun" required>
                        </div>
                        <div class="mb-3">
                            <label for="tipeAkun" class="form-label">Tipe Akun</label>
                            <select class="form-select" id="tipeAkun" name="tipe_akun" required>
                                <option value="debit">Debit</option>
                                <option value="kredit">Kredit</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="nominalAkun" class="form-label">Nominal</label>
                            <input type="number" class="form-control" id="nominalAkun" name="nominal" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Tambah</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/neracaSaldo.blade.php ENDPATH**/ ?>