@extends('dashboard.layouts.main')

@section('container')
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Customer</h1>
</div>

<form action="{{ route('customer.index') }}" method="GET">
    <div class="input-group mb-3">
        <input type="text" class="form-control" placeholder="Search" name="search" value="{{ request('search') }}">
        <button class="btn btn-danger" type="submit">Search</button>
    </div>
</form>

<div class="row">
    <div class="col-lg-12">
        <div class="card card-default rounded-0 shadow">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                        <h3 class="card-title">Customer List</h3>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6" align="right">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addCustomerModal">
                            <i class="far fa-plus-square"></i> Add Customer
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-12 table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nama</th>
                                    <th>Alamat</th>
                                    <th>No Telp</th>
                                    <th>Mobil</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($customers as $customer)
                                <tr>
                                    <td><b>{{ $customer->id }}</b></td>
                                    <td>{{ $customer->nama }}</td>
                                    <td>{{ $customer->alamat }}</td>
                                    <td>{{ $customer->telp }}</td>
                                    <td>
                                        @foreach ($customer->mobil as $mobil)
                                            {{ $mobil->type }}@if (!$loop->last), @endif
                                        @endforeach
                                    </td>
                                    <td>
                                        <a class="badge bg-warning" data-bs-toggle="modal" data-bs-target="#editCustomerModal{{ $customer->id }}">
                                            <i class="bi bi-pencil" style="cursor: pointer;"></i>
                                        </a>
                                        <form action="{{ route('customer.destroy', $customer) }}" method="POST" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button class="badge bg-danger border-0" onclick="return confirm('Are You Sure ?')">
                                                <i class="bi bi-trash3"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modal for adding customer --}}
<div id="addCustomerModal" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Customer</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" onclick="refreshPage()"  aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <form method="POST" action="{{ route('customer.store') }}">
                        @csrf
                        <div class="mb-3">
                            <label class="control-label">Nama</label>
                            <input type="text" name="nama" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">No Telp</label>
                            <input type="number" name="telp" class="form-control rounded-0" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">Alamat</label>
                            <textarea name="alamat" class="form-control rounded-0" rows="5" required></textarea>
                        </div>
                        <div id="mobilFields">
                            <div class="mb-3 d-flex">
                                <div class="flex-grow-1 me-2">
                                    <label class="control-label">Mobil</label>
                                    <input type="text" name="mobil[0][type]" class="form-control rounded-0" placeholder="Type" required>
                                </div>
                                <div class="flex-grow-1 ms-2">
                                    <label class="control-label">No Polisi</label>
                                    <input type="text" name="mobil[0][no_polisi]" class="form-control rounded-0" placeholder="No Polisi" required>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="addMobilField">
                            Add Mobil
                        </button>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Tambah Customer</button>
                            <button type="button" class="btn btn-danger" onclick="refreshPage()" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modal for editing customer --}}
@foreach ($customers as $customer)
<div id="editCustomerModal{{ $customer->id }}" class="modal fade">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Customer</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <form method="POST" action="{{ route('customer.update', $customer) }}">
                        @csrf
                        @method('PUT')
                        <div class="mb-3">
                            <label class="control-label">Nama</label>
                            <input type="text" name="nama" class="form-control rounded-0" value="{{ $customer->nama }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">No Telp</label>
                            <input type="number" name="telp" class="form-control rounded-0" value="{{ $customer->telp }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="control-label">Alamat</label>
                            <textarea name="alamat" class="form-control rounded-0" rows="5" required>{{ $customer->alamat }}</textarea>
                        </div>
                        <div id="mobilFieldsEdit{{ $customer->id }}">
                            @foreach ($customer->mobil as $index => $mobil)
                            <div class="mb-3 d-flex">
                                <div class="flex-grow-1 me-2">
                                    <label class="control-label">Mobil</label>
                                    <input type="text" name="mobil[{{ $index }}][type]" class="form-control rounded-0" value="{{ $mobil->type }}" placeholder="Type" required>
                                </div>
                                <div class="flex-grow-1 ms-2">
                                    <label class="control-label">No Polisi</label>
                                    <input type="text" name="mobil[{{ $index }}][no_polisi]" class="form-control rounded-0" value="{{ $mobil->no_polisi }}" placeholder="No Polisi" required>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        <button type="button" class="btn btn-secondary mt-2" id="addMobilFieldEdit{{ $customer->id }}">
                            Add Mobil
                        </button>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">Update Customer</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endforeach

@endsection

@section('scripts')
<script>
    let mobilIndex = 1;
    document.getElementById('addMobilField').addEventListener('click', function () {
        const mobilFields = document.getElementById('mobilFields');
        const newFields = document.createElement('div');
        newFields.classList.add('mb-3', 'd-flex');
        newFields.innerHTML = `
            <div class="flex-grow-1 me-2">
                <label class="control-label">Mobil</label>
                <input type="text" name="mobil[${mobilIndex}][type]" class="form-control rounded-0" placeholder="Type">
            </div>
            <div class="flex-grow-1 ms-2">
                <label class="control-label">No Polisi</label>
                <input type="text" name="mobil[${mobilIndex}][no_polisi]" class="form-control rounded-0" placeholder="No Polisi">
            </div>
        `;
        mobilFields.appendChild(newFields);
        mobilIndex++;
    });


    @foreach ($customers as $customer)
    let mobilIndexEdit{{ $customer->id }} = {{ count($customer->mobil) }};
    document.getElementById('addMobilFieldEdit{{ $customer->id }}').addEventListener('click', function () {
        const mobilFieldsEdit = document.getElementById('mobilFieldsEdit{{ $customer->id }}');
        const newFields = document.createElement('div');
        newFields.classList.add('mb-3', 'd-flex');
        newFields.innerHTML = `
            <div class="flex-grow-1 me-2">
                <label class="control-label">Mobil</label>
                <input type="text" name="mobil[${mobilIndexEdit{{ $customer->id }} }][type]" class="form-control rounded-0" placeholder="Type">
            </div>
            <div class="flex-grow-1 ms-2">
                <label class="control-label">No Polisi</label>
                <input type="text" name="mobil[${mobilIndexEdit{{ $customer->id }} }][no_polisi]" class="form-control rounded-0" placeholder="No Polisi">
            </div>
        `;
        mobilFieldsEdit.appendChild(newFields);
        mobilIndexEdit{{ $customer->id }}++;
    });
    @endforeach
</script>
<script>
    function refreshPage() {
        location.reload();
    }
    </script>
@endsection
