<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">data</h1>
    </div>

    <div class="row">
        <div class="col-lg-3">
            <label for="nopol" class="form-label">Nomor Nota</label>
            <div class="input-group">
                <input type="text" class="form-control" value="<?php echo e($data->id); ?>" disabled>
            </div>
        </div>
        
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <form method="post" action="/data" class="mb-3">
                <label for="nama" class="form-label">Nama</label>
                <input type="text" class="form-control"
                    <?php if($data): ?> value="<?php echo e($data->nama); ?>" <?php endif; ?> id="notelp" name="notelp"
                    disabled>
        </div>

        
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <div class="mb-">
                <label for="notelp" class="form-label">No Telpon</label>
                <input type="text" class="form-control"
                    <?php if($data): ?> value="<?php echo e($data->telp); ?>" <?php endif; ?> id="notelp" name="notelp"
                    disabled>

            </div>
        </div>


        
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <label for="jenis" class="form-label">Jenis Mobil</label>
            <input type="text" class="form-control"
                <?php if($data): ?> value="<?php echo e($data->jenis_mobil); ?>" <?php endif; ?> id="notelp" name="notelp"
                disabled>
        </div>
    </div>


    <div class="row">
        
        <div class="col-lg-3">

            <?php echo csrf_field(); ?>
            <label for="nopol" class="form-label">No Polisi</label>
            <div class="input-group">
                <input type="text" class="form-control <?php $__errorArgs = ['nopol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="nopol"
                    <?php if($data): ?> value="<?php echo e($data->no_polisi); ?>" <?php endif; ?> name="nopol" required
                    value="<?php echo e(old('nopol')); ?>" disabled>
            </div>
        </div>

        
        <div class="col-lg-3">
            <form action="<?php echo e(route('tambahHistory')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <label for="kilometer" class="form-label">Kilometer</label>
                <input type="text" class="form-control  <?php $__errorArgs = ['kilometer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="kilometer"
                    name="kilometer" required value="<?php echo e($data->kilometer); ?>">
                <?php $__errorArgs = ['kilometer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback">
                        <?php echo e($message); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="col-lg-3 mb-3">
            <label for="pegawai" class="form-label">Pegawai</label>
            <select class="form-select" name="employee_id" disabled>
                <option value="">-Pilih Pegawai-</option>
                <?php $__currentLoopData = $pegawai; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $peg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($peg->id); ?>" <?php if($peg->id == $data->employee_id): ?> selected <?php endif; ?>>
                        <?php echo e($peg->nama); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        

    </div>
    <div class="row mb-3">
        <div class="col-lg-3">
            <input type="hidden" name="customer_id"
                <?php if($data): ?> value="<?php echo e($data->customer_id); ?>" <?php endif; ?> id="">
            <button class="btn btn-primary">Update</button>
            </form>
        </div>
    </div>
    <div class="row">
        
        <div class="row">
            <div class="col-lg-12">
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th scope="col">No</th>
                                <th scope="col">Nama Barang/Jasa</th>
                                <th scope="col">Jumlah</th>
                                <th scope="col">Satuan</th>
                                <th scope="col">Harga</th>
                                <th scope="col" style="width: 150px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $no = 1;
                            ?>
                            <?php $__currentLoopData = $service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($no++); ?></td>
                                    <td><?php echo e($ser->nama_barang); ?> <?php echo e($ser->jasa); ?></td>
                                    <td><?php echo e($ser->jumlah); ?></td>
                                    <td><?php echo e($ser->satuan); ?></td>
                                    <td>Rp. <?php echo e(number_format($ser->total_harga)); ?></td>
                                    <td>
                                        <a class="badge bg-warning" data-bs-toggle="modal"
                                            data-bs-target="#edit<?php echo e($ser->id); ?>"><i class="bi bi-pencil"
                                                style="cursor: pointer;"></i></a>
                                        <div class="modal fade" id="edit<?php echo e($ser->id); ?>" tabindex="-1"
                                            aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Edit Data</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form method="post"
                                                            action="<?php echo e(route('updateService', $data->id)); ?>">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <div class="mb-3">
                                                                <input type="hidden" value="<?php echo e($ser->id); ?>"
                                                                    name="id_service" id="">
                                                                <label class="control-label">Nama Jasa</label>
                                                                <input type="text" class="form-control"
                                                                    value="<?php echo e($ser->jasa); ?>" name="jasa"
                                                                    id="">
                                                            </div>
                                                            <div class="mb-3">
                                                                <div class="form-group">
                                                                    <label class="control-label">Nama Barang</label>
                                                                    <select name="stock_id" class="form-control"
                                                                        id="">
                                                                        <option value="">-Pilih Barang-</option>
                                                                        <?php $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($item->id); ?>"
                                                                                <?php if($item->id == $ser->stock_id): ?> selected <?php endif; ?>>
                                                                                <?php echo e($item->nama_barang); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="control-label">Jumlah</label>
                                                                <input type="number" class="form-control"
                                                                    value="<?php echo e($ser->jumlah); ?>" name="jumlah"
                                                                    id="">
                                                                <?php
                                                                    $stk = DB::table('stock')
                                                                        ->where('id', $ser->stock_id)
                                                                        ->first();
                                                                ?>
                                                                <?php if($ser->stock_id != null): ?>
                                                                <input type="hidden" value="<?php echo e($stk->jumlah_barang+$ser->jumlah); ?>" name="jumlah_barang" id="">
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="satuan" class="form-label">Satuan</label>
                                                                <select class="form-select" name="satuan">
                                                                    <option value="-"
                                                                        <?php if($ser->satuan == '-'): ?> selected <?php endif; ?>>-
                                                                    </option>
                                                                    <option value="ltr"
                                                                        <?php if($ser->satuan == 'ltr'): ?> selected <?php endif; ?>>
                                                                        ltr</option>
                                                                    <option value="pcs"
                                                                        <?php if($ser->satuan == 'pcs'): ?> selected <?php endif; ?>>
                                                                        pcs</option>
                                                                </select>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="control-label">Harga</label>
                                                                <?php
                                                                    $harga_satuan = $ser->total_harga / $ser->jumlah;
                                                                ?>
                                                                <input type="number" class="form-control"
                                                                    value="<?php echo e($harga_satuan); ?>" name="harga_barang"
                                                                    id="">
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn-success">Update</button>
                                                                <button type="button" class="btn btn-danger"
                                                                    data-bs-dismiss="modal">Cancel</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <form action="<?php echo e(route('deleteService', $data->id)); ?>" method="post"
                                            style="display: inline-block;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <input type="hidden" name="id_service" value="<?php echo e($ser->id); ?>"
                                                id="">
                                            <button class="badge bg-danger border-0"
                                                onclick="return confirm('Are You Sure ?')"><i
                                                    class="bi bi-trash3"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td colspan="3"></td>
                                <th>Total</th>
                                <th>Rp. <?php echo e(number_format($total)); ?></th>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        
        <div class="col-lg-2">
            <form action="<?php echo e(route('tambahService', $data->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <label for="jasa" class="form-label">Nama Jasa</label>
                <input type="text" class="form-control  <?php $__errorArgs = ['jasa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="jasa"
                    name="jasa" value="<?php echo e(old('jasa')); ?>">
                <?php $__errorArgs = ['jasa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="invalid-feedback">
                        <?php echo e($message); ?>

                    </div>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>
        
        <div class="col-lg-2">
            <label for="stock_id" class="form-label">Nama Barang</label>
            <select class="form-select" name="stock_id" id="stock_id">
                <option value="">-Pilih Barang-</option>
                <?php $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($stk->id); ?>"><?php echo e($stk->nama_barang); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        
        <div class="col-lg-1"> <!-- Adjust the column width as needed -->
            <div class="mb-">
                <label for="jumlah" class="form-label">Jumlah</label>
                <input type="number" min=1 class="form-control  <?php $__errorArgs = ['jumlah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="jumlah"
                    name="jumlah" required value="<?php echo e(old('jumlah')); ?>">
            </div>
        </div>
        
        <div class="col-lg-1"> <!-- Adjust the column width as needed -->
            <label for="satuan" class="form-label">Satuan</label>
            <select class="form-select" name="satuan">
                <option value="-">-</option>
                <option value="ltr">ltr</option>
                <option value="pcs">pcs</option>
            </select>
        </div>
        
        <div class="col-lg-2">
            <label for="harga_barang" class="form-label">Harga Satuan</label>
            <input type="text" class="form-control" name="harga_barang" id="harga_barang">
        </div>
        
        <div class="col-lg-2">
            <label for="total_harga" class="form-label">Jumlah Harga</label>
            <input type="text" name="total_harga" id="total_harga" class="form-control" disabled>
        </div>
        
        <div class="col-lg-2">
            <button type="submit" class="btn btn-primary btn-lg" id="tambahBtn">+ Tambah +</button>
            </form>
        </div>
    </div>
    
    <form action="<?php echo e(route('updateHistory', $data->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="row">
            <div class="col-lg-2 md-2">
                <label for="total" class="form-label">Total</label>
                <input type="hidden" id="abc" value="<?php echo e($total); ?>" name="" id="">
                <input type="text" name="harga_akhir" value="<?php echo e($total); ?>" id="harga_akhir"
                    class="form-control" disabled>
                <input type="hidden" name="harga_total" id="harga_akhir">
            </div>
            
            <div class="row">
                <div class="col-lg-2 mb-3">
                    <label for="discount" class="form-label">Discount</label>
                    <div class="input-group"> <!-- Add input group -->
                        <input type="text" class="form-control" id="discount" name="discount" required
                            <?php if($data->discount): ?> value="<?php echo e($data->discount); ?>"
                            <?php else: ?>
                            value="0" <?php endif; ?>>
                        <span class="input-group-text"><b>%</b></span> <!-- Add the percentage sign -->
                    </div>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-success">Save</button>
    </form>
    
<?php $__env->stopSection(); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        function calculateTotalHarga() {
            var hargaBarang = parseFloat($('#harga_barang').val());
            var jumlah = parseInt($('#jumlah').val());
            if (!isNaN(hargaBarang) && !isNaN(jumlah)) {
                var totalHarga = hargaBarang * jumlah;
                $('#total_harga').val(totalHarga);
                calculateHargaAkhir(); // Panggil fungsi untuk menghitung harga akhir
            } else {
                $('#total_harga').val('');
            }
        }

        function calculateHargaAkhir() {
            var totalHarga = parseFloat($('#abc').val());
            var discount = parseFloat($('#discount').val());
            if (!isNaN(totalHarga) && !isNaN(discount)) {
                var hargaAkhir = totalHarga - (totalHarga * (discount / 100));
                $('#harga_akhir').val(hargaAkhir); // Format ke dua angka di belakang koma
            } else {
                $('#harga_akhir').val('');
            }
        }

        $('#stock_id').change(function() {
            var stockId = $(this).val();
            if (stockId) {
                $.ajax({
                    url: '/get-stock/' + stockId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data.harga_barang !== null) {
                            $('#harga_barang').val(data.harga_barang);
                            calculateTotalHarga();
                        } else {
                            $('#harga_barang').val('');
                            $('#total_harga').val('');
                            $('#harga_akhir').val('');
                        }
                    },
                    error: function() {
                        $('#harga_barang').val('');
                        $('#total_harga').val('');
                        $('#harga_akhir').val('');
                    }
                });
            } else {
                $('#harga_barang').val('');
                $('#total_harga').val('');
                $('#harga_akhir').val('');
            }
        });

        $('#jumlah, #discount').on('input', function() {
            calculateTotalHarga();
        });

        $('#discount').on('input', function() {
            calculateHargaAkhir();
        });
    });
</script>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Files\2024\05 - Bengkel\bengkel\resources\views/service/service.blade.php ENDPATH**/ ?>