<?php $__env->startSection('container'); ?>
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">History</h1>
    </div>
    <form action="<?php echo e(route('history.index')); ?>" method="GET">
    <div class="input-group mb-3">
        <input type="text" class="form-control" placeholder="Search" name="search" value="<?php echo e(request('search')); ?>">
        <input type="date" class="form-control" name="start_date" value="<?php echo e(request('start_date')); ?>">
        <input type="date" class="form-control" name="end_date" value="<?php echo e(request('end_date')); ?>">
        <button class="btn btn-danger" type="submit">Search</button>
    </div>
</form>

    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">History</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="supplierList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Customer</th>
                                        <th>No Polisi</th>
                                        <th>Nama Employee</th>
                                        <th>Discount</th>
                                        <th>Total Harga</th>
                                        <th>Tanggal</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $no = 1;
                                    ?>
                                    <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($no++); ?></td>
                                        <td>
                                            <a href="#modal<?php echo e($data->id); ?>" data-bs-toggle="modal"><?php echo e($data->nama); ?></a>
                                        </td>
                                        <td><?php echo e($data->no_polisi); ?></td>
                                        <td><?php echo e($data->nama_pegawai); ?></td>
                                        <td><?php echo e($data->discount); ?>%</td>
                                        <td>Rp. <?php echo e(number_format($data->harga_total)); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d-m-Y')); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('history.print', $data->id)); ?>" target="_BLANK" class="badge bg-success"><i class="bi bi-printer" style="cursor: pointer;"></i></a>
                                            <a href="<?php echo e(route('service', $data->id)); ?>" class="badge bg-warning"><i class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                            <form action="<?php echo e(route('deleteHistory', $data->id)); ?>" method="post" style="display: inline-block;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button class="badge bg-danger border-0" onclick="return confirm('Are You Sure ?')"><i class="bi bi-trash3"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <?php $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!-- Modal -->
                            <div class="modal fade" id="modal<?php echo e($data->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered" >
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel"><?php echo e($data->nama); ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>No Polisi:</strong> <?php echo e($data->no_polisi); ?></p>
                                            <p><strong>Pegawai:</strong> <?php echo e($data->nama_pegawai); ?></p>
                                            <p><strong>Detail Service:</strong></p>
                                            <div class="table-responsive">
                                                <table class="table table-bordered table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>No</th>
                                                            <th>Nama Barang/Jasa</th>
                                                            <th>Jumlah</th>
                                                            <th>Satuan</th>
                                                            <th>Harga</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                            $serviceNo = 1;
                                                        ?>
                                                        <?php $__currentLoopData = $data->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($serviceNo++); ?></td>
                                                            <td><?php echo e(optional($service->stock)->nama_barang); ?> <?php echo e($service->jasa); ?></td>
                                                            <td><?php echo e($service->jumlah); ?></td>
                                                            <td><?php echo e($service->satuan); ?></td>
                                                            <td>Rp. <?php echo e(number_format($service->total_harga)); ?></td>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <p><strong>Discount:</strong> <?php echo e($data->discount); ?>%</p>
                                            <p><strong>Total Harga:</strong> Rp. <?php echo e(number_format($data->harga_total)); ?></p>
                                            <p><strong>Tanggal:</strong> <?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d-m-Y')); ?></p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Coding Skripsi\bengkel\resources\views/history.blade.php ENDPATH**/ ?>