@extends('dashboard.layouts.main')
@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Service</h1>
    </div>

    <div class="row">
        <div class="col-lg-3">
            <label for="nopol" class="form-label">Nomor Nota</label>
            <div class="input-group">
                <input type="text" class="form-control" value="{{ $data->id }}" disabled>
            </div>
        </div>
        {{-- Form Nama --}}
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <form method="post" action="/data" class="mb-3">
                <label for="nama" class="form-label">Nama</label>
                <input type="text" class="form-control"
                    @if ($data) value="{{ $data->nama }}" @endif id="notelp" name="notelp"
                    disabled>
        </div>

        {{-- form no telp --}}
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <div class="mb-">
                <label for="notelp" class="form-label">No Telpon</label>
                <input type="text" class="form-control"
                    @if ($data) value="{{ $data->telp }}" @endif id="notelp" name="notelp"
                    disabled>

            </div>
        </div>


        {{-- jenis mobil --}}
        <div class="col-lg-3"> <!-- Adjust the column width as needed -->
            <label for="jenis" class="form-label">Jenis Mobil</label>
            <input type="text" class="form-control"
                @if ($data) value="{{ $data->jenis_mobil }}" @endif id="notelp" name="notelp"
                disabled>
        </div>
    </div>


    <div class="row">
        {{-- form nopol --}}
        <div class="col-lg-3">

            @csrf
            <label for="nopol" class="form-label">No Polisi</label>
            <div class="input-group">
                <input type="text" class="form-control @error('nopol') is-invalid @enderror" id="nopol"
                    @if ($data) value="{{ $data->no_polisi }}" @endif name="nopol" required
                    value="{{ old('nopol') }}" disabled>
            </div>
        </div>

        {{-- form kilometer --}}
        <div class="col-lg-3">
            <form action="{{ route('tambahHistory') }}" method="POST">
                @csrf
                <label for="kilometer" class="form-label">Kilometer</label>
                <input type="text" class="form-control  @error('kilometer') is-invalid @enderror" id="kilometer"
                    name="kilometer" required value="{{ $data->kilometer }}">
                @error('kilometer')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
        </div>
        {{-- form pegawai yang melakukan data --}}
        <div class="col-lg-3 mb-3">
            <label for="pegawai" class="form-label">Pegawai</label>
            <select class="form-select" name="employee_id" disabled>
                <option value="">-Pilih Pegawai-</option>
                @foreach ($pegawai as $peg)
                    <option value="{{ $peg->id }}" @if ($peg->id == $data->employee_id) selected @endif>
                        {{ $peg->nama }}</option>
                @endforeach
            </select>
        </div>

        {{-- form waktu data --}}

    </div>
    <div class="row mb-3">
        <div class="col-lg-3">
            <input type="hidden" name="customer_id"
                @if ($data) value="{{ $data->customer_id }}" @endif id="">
            <button class="btn btn-primary">Update</button>
            </form>
        </div>
    </div>
    <div class="row">
        {{-- Table --}}
        <div class="row">
            <div class="col-lg-12">
                <div class="table-responsive">
                    <table class="table table-hover table-striped">
                        <thead class="table-dark">
                            <tr>
                                <th scope="col">No</th>
                                <th scope="col">Nama Barang/Jasa</th>
                                <th scope="col">Jumlah</th>
                                <th scope="col">Satuan</th>
                                <th scope="col">Harga</th>
                                <th scope="col" style="width: 150px;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $no = 1;
                            @endphp
                            @foreach ($service as $ser)
                                <tr>
                                    <td>{{ $no++ }}</td>
                                    <td>{{ $ser->nama_barang }} {{ $ser->jasa }}</td>
                                    <td>{{ $ser->jumlah }}</td>
                                    <td>{{ $ser->satuan }}</td>
                                    <td>Rp. {{ number_format($ser->total_harga) }}</td>
                                    <td>
                                        <a class="badge bg-warning" data-bs-toggle="modal"
                                            data-bs-target="#edit{{ $ser->id }}"><i class="bi bi-pencil"
                                                style="cursor: pointer;"></i></a>
                                        <div class="modal fade" id="edit{{ $ser->id }}" tabindex="-1"
                                            aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Edit Data</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                            aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <form method="post"
                                                            action="{{ route('updateService', $data->id) }}">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="mb-3">
                                                                <input type="hidden" value="{{ $ser->id }}"
                                                                    name="id_service" id="">
                                                                <label class="control-label">Nama Jasa</label>
                                                                <input type="text" class="form-control"
                                                                    value="{{ $ser->jasa }}" name="jasa"
                                                                    id="">
                                                            </div>
                                                            <div class="mb-3">
                                                                <div class="form-group">
                                                                    <label class="control-label">Nama Barang</label>
                                                                    <select name="stock_id" class="form-control"
                                                                        id="">
                                                                        <option value="">-Pilih Barang-</option>
                                                                        @foreach ($stock as $item)
                                                                            <option value="{{ $item->id }}"
                                                                                @if ($item->id == $ser->stock_id) selected @endif>
                                                                                {{ $item->nama_barang }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="control-label">Jumlah</label>
                                                                <input type="number" class="form-control"
                                                                    value="{{ $ser->jumlah }}" name="jumlah"
                                                                    id="">
                                                                @php
                                                                    $stk = DB::table('stock')
                                                                        ->where('id', $ser->stock_id)
                                                                        ->first();
                                                                @endphp
                                                                @if ($ser->stock_id != null)
                                                                <input type="hidden" value="{{ $stk->jumlah_barang+$ser->jumlah }}" name="jumlah_barang" id="">
                                                                @endif
                                                            </div>
                                                            <div class="mb-3">
                                                                <label for="satuan" class="form-label">Satuan</label>
                                                                <select class="form-select" name="satuan">
                                                                    <option value="-"
                                                                        @if ($ser->satuan == '-') selected @endif>-
                                                                    </option>
                                                                    <option value="ltr"
                                                                        @if ($ser->satuan == 'ltr') selected @endif>
                                                                        ltr</option>
                                                                    <option value="pcs"
                                                                        @if ($ser->satuan == 'pcs') selected @endif>
                                                                        pcs</option>
                                                                </select>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="control-label">Harga</label>
                                                                @php
                                                                    $harga_satuan = $ser->total_harga / $ser->jumlah;
                                                                @endphp
                                                                <input type="number" class="form-control"
                                                                    value="{{ $harga_satuan }}" name="harga_barang"
                                                                    id="">
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn-success">Update</button>
                                                                <button type="button" class="btn btn-danger"
                                                                    data-bs-dismiss="modal">Cancel</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <form action="{{ route('deleteService', $data->id) }}" method="post"
                                            style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <input type="hidden" name="id_service" value="{{ $ser->id }}"
                                                id="">
                                            <button class="badge bg-danger border-0"
                                                onclick="return confirm('Are You Sure ?')"><i
                                                    class="bi bi-trash3"></i></button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                            <tr>
                                <td colspan="3"></td>
                                <th>Total</th>
                                <th>Rp. {{ number_format($total) }}</th>
                                <td></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        {{-- Form Nama jasa --}}
        <div class="col-lg-2">
            <form action="{{ route('tambahService', $data->id) }}" method="POST">
                @csrf
                <label for="jasa" class="form-label">Nama Jasa</label>
                <input type="text" class="form-control  @error('jasa') is-invalid @enderror" id="jasa"
                    name="jasa" value="{{ old('jasa') }}">
                @error('jasa')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
        </div>
        {{-- Form nama barang --}}
        <div class="col-lg-2">
            <label for="stock_id" class="form-label">Nama Barang</label>
            <select class="form-select" name="stock_id" id="stock_id">
                <option value="">-Pilih Barang-</option>
                @foreach ($stock as $stk)
                    <option value="{{ $stk->id }}">{{ $stk->nama_barang }}</option>
                @endforeach
            </select>
        </div>

        {{-- form jumlah --}}
        <div class="col-lg-1"> <!-- Adjust the column width as needed -->
            <div class="mb-">
                <label for="jumlah" class="form-label">Jumlah</label>
                <input type="number" min=1 class="form-control  @error('jumlah') is-invalid @enderror" id="jumlah"
                    name="jumlah" required value="{{ old('jumlah') }}">
            </div>
        </div>
        {{-- form satuan --}}
        <div class="col-lg-1"> <!-- Adjust the column width as needed -->
            <label for="satuan" class="form-label">Satuan</label>
            <select class="form-select" name="satuan">
                <option value="-">-</option>
                <option value="ltr">ltr</option>
                <option value="pcs">pcs</option>
            </select>
        </div>
        {{-- form harga --}}
        <div class="col-lg-2">
            <label for="harga_barang" class="form-label">Harga Satuan</label>
            <input type="text" class="form-control" name="harga_barang" id="harga_barang">
        </div>
        {{-- form jumlah harga --}}
        <div class="col-lg-2">
            <label for="total_harga" class="form-label">Jumlah Harga</label>
            <input type="text" name="total_harga" id="total_harga" class="form-control" disabled>
        </div>
        {{-- tombol tambah data --}}
        <div class="col-lg-2">
            <button type="submit" class="btn btn-primary btn-lg" id="tambahBtn">+ Tambah +</button>
            </form>
        </div>
    </div>
    {{-- form harga total --}}
    <form action="{{ route('updateHistory', $data->id) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-lg-2 md-2">
                <label for="total" class="form-label">Total</label>
                <input type="hidden" id="abc" value="{{ $total }}" name="" id="">
                <input type="text" name="harga_akhir" value="{{ number_format($total) }}" id="harga_akhir"
                    class="form-control" disabled>
                <input type="hidden" name="harga_total" id="harga_akhir">
            </div>
            {{-- form discount --}}
            <div class="row">
                <div class="col-lg-2 mb-3">
                    <label for="discount" class="form-label">Discount</label>
                    <div class="input-group"> <!-- Add input group -->
                        <input type="text" class="form-control" id="discount" name="discount" required
                            @if ($data->discount) value="{{ $data->discount }}"
                            @else
                            value="0" @endif>
                        <span class="input-group-text"><b>%</b></span> <!-- Add the percentage sign -->
                    </div>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-success">Save</button>
    </form>
    {{-- <button type="print" class="btn btn-primary">Print</button> --}}
@endsection
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        function calculateTotalHarga() {
            var hargaBarang = parseFloat($('#harga_barang').val());
            var jumlah = parseInt($('#jumlah').val());
            if (!isNaN(hargaBarang) && !isNaN(jumlah)) {
                var totalHarga = hargaBarang * jumlah;
                $('#total_harga').val(totalHarga);
                calculateHargaAkhir(); // Panggil fungsi untuk menghitung harga akhir
            } else {
                $('#total_harga').val('');
            }
        }

        function calculateHargaAkhir() {
            var totalHarga = parseFloat($('#abc').val());
            var discount = parseFloat($('#discount').val());
            if (!isNaN(totalHarga) && !isNaN(discount)) {
                var hargaAkhir = totalHarga - (totalHarga * (discount / 100));
                $('#harga_akhir').val(hargaAkhir); // Format ke dua angka di belakang koma
            } else {
                $('#harga_akhir').val('');
            }
        }

        $('#stock_id').change(function() {
            var stockId = $(this).val();
            if (stockId) {
                $.ajax({
                    url: '/get-stock/' + stockId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        if (data.harga_barang !== null) {
                            $('#harga_barang').val(data.harga_barang);
                            calculateTotalHarga();
                        } else {
                            $('#harga_barang').val('');
                            $('#total_harga').val('');
                            $('#harga_akhir').val('');
                        }
                    },
                    error: function() {
                        $('#harga_barang').val('');
                        $('#total_harga').val('');
                        $('#harga_akhir').val('');
                    }
                });
            } else {
                $('#harga_barang').val('');
                $('#total_harga').val('');
                $('#harga_akhir').val('');
            }
        });

        $('#jumlah, #discount').on('input', function() {
            calculateTotalHarga();
        });

        $('#discount').on('input', function() {
            calculateHargaAkhir();
        });
    });
</script>
