<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('history', function (Blueprint $table) {
            $table->id();
            $table->foreignID('customer_id')->nullable();
            $table->foreignID('employee_id');
            $table->string('jenis_mobil');
            $table->integer('kilometer');
            $table->string('no_polisi');
            $table->integer('discount')->nullable();
            $table->bigInteger('harga_total')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('history');
    }
};
