package models

import (
	"github.com/jinzhu/gorm"
	"github.com/revel/revel"
)

type Soal struct {
	gorm.Model
	ID              uint64 `gorm:"default:0;"`
	Soal            string `gorm:"size:32; not null;"`
	PilihanJawaban  []PilihanJawaban
	// Pilihan_jawaban string `gorm:"size:32; not null;"`
	// Kunci_jawaban   string `gorm:"size:32; not null;"`
	Kesulitan       uint64 `gorm:"default:0;"`
	ID_Materi       uint64 //foreign key tabel Materi
	Materi          Materi
	ID_jenis_soal   uint64 //foreign key tabel jenis soal
	JenisSoal       JenisSoal
	Images          string
}

func (m *Soal) Validate(v *revel.Validation) {

	v.Required(m.Soal).Message("Soal tidak boleh kosong")

	v.Required(m.Kesulitan).Message("Kesulitan tidak boleh kosong")
}
