package models

import (
	"github.com/jinzhu/gorm"
	"github.com/revel/revel"
)

type PilihanJawaban struct {
	gorm.Model
	ID      uint64 `gorm:"default:0;"`
	ID_soal uint64 `gorm:"default:0;"`

	Pilihan string `gorm:"size:32; not null;"`
	IsTrue  bool   `gorm:"default:false;"`
	IgnoreCase  bool   `gorm:"default:false;"`
}

func (m *PilihanJawaban) Validate(v *revel.Validation) {
	v.Required(m.Pilihan).Message("Pilihan tidak boleh kosong")
	v.Required(m.IsTrue).Message("Is True tidak boleh kosong")
	v.Required(m.IgnoreCase).Message("Ignore Case tidak boleh kosong")
}
