package models

import (
	"github.com/revel/revel"
)

type MataKuliah struct {
	Kode      string `gorm:"size:32; not null;"`
	Nama      string `gorm:"size:32; not null;"`
	SKS       uint64 `gorm:"default:0;"`
	Deskripsi string `gorm:"size:32; not null;"`
}

func (m *MataKuliah) Validate(v *revel.Validation) {
	v.Required(m.Nama).Message("Nama tidak boleh kosong")
	v.Required(m.Kode).Message("Kode mata kuliah tidak boleh kosong")
	v.Required(m.SKS).Message("SKS tidak boleh kosong")

}
