@extends('dashboard.layouts.main')

@section('container')
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Update Stock Opname</h1>
    <a href="/stock_opname" class="btn btn-primary">Back</a>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card card-default rounded-0 shadow">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                        <h3 class="card-title">Stock Opname</h3>
                    </div>
                    <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                        <!-- You can add buttons or links here if needed -->
                    </div>
                </div>
                <div class="clear:both"></div>
            </div>
            <div class="card-body">
                @if($stock_opname->isEmpty())
                    <div class="alert alert-info" role="alert">
                        No stock available.
                    </div>
                @else
                    <form action="{{ route('stock_opname.update') }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-sm-12 table-responsive">
                                <table id="stockOpnameList" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Id Barang</th>
                                            <th>Nama Barang</th>
                                            <th>Stock Awal</th>
                                            <th>Stock Akhir</th>
                                            <th>Selisih</th>
                                            <th>Catatan</th>
                                            <th>Tanggal Opname</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($stock_opname as $stock)
                                        <tr>
                                            <td>{{ $stock->id }}</td>
                                            <td>{{ $stock->nama_barang }}</td>
                                            <td>{{ $stock->jumlah_barang }}</td>
                                            <td>
                                                <input type="number" name="jumlah_akhir[{{ $stock->id }}]" value="{{ old('jumlah_akhir.'.$stock->id, $stock->jumlah_barang) }}" class="form-control" data-stock-awal="{{ $stock->jumlah_barang }}" data-id="{{ $stock->id }}" oninput="calculateSelisih(this)">
                                            </td>
                                            <td>
                                                <input type="text" name="selisih[{{ $stock->id }}]" value="{{ old('selisih.'.$stock->id, 0) }}" class="form-control selisih" data-id="{{ $stock->id }}" readonly>
                                            </td>
                                            <td>
                                                <input type="text" name="catatan[{{ $stock->id }}]" value="{{ old('catatan.'.$stock->id) }}" class="form-control">
                                            </td>
                                            <td>{{ now()->toDateString() }}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-sm-12 text-end">
                                <button type="submit" class="btn btn-primary">Update Stock Opname</button>
                            </div>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
function calculateSelisih(input) {
    const stockAwal = parseInt(input.getAttribute('data-stock-awal'));
    const stockAkhir = parseInt(input.value);
    const selisihInput = document.querySelector(`.selisih[data-id="${input.getAttribute('data-id')}"]`);

    let selisih = stockAkhir - stockAwal;
    selisihInput.value = selisih > 0 ? `+${selisih}` : selisih;
}

// Initialize selisih values on page load
document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('input[name^="jumlah_akhir"]').forEach(input => {
        calculateSelisih(input);
    });
});
</script>
@endsection
