@extends('dashboard.layouts.main')
@section('container')
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Pembelian</h1>
    </div>
    <form action="{{ route('pembelian.index') }}" method="GET">
        <div class="input-group mb-3">
            <input type="text" class="form-control" placeholder="Search" name="search" value="{{ request('search') }}">
            <button class="btn btn-danger" type="submit">Search</button>
        </div>
    </form>
    <div class="row">
        <div class="col-lg-12">
            <div class="card card-default rounded-0 shadow">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-10 col-md-10 col-sm-8 col-xs-6">
                            <h3 class="card-title">List Pembelian</h3>
                        </div>
                        <div class="col-lg-2 col-md-2 col-sm-4 col-xs-6 text-end">
                            <button type="button" id="addPembelian" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#addPembelianModal"><i class="far fa-plus-square"></i> Add Pembelian</button>
                        </div>
                    </div>
                    <div class="clear:both"></div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 table-responsive">
                            <table id="supplierList" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Nama Supplier</th>
                                        <th>Nama Barang</th>
                                        <th>Jumlah</th>
                                        <th>Harga / Barang</th>
                                        <th>Total</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($pembelians as $pembelian)
                                        <tr>
                                            <td><b>{{ $pembelian->id }}</b></td>
                                            <td>{{ $pembelian->nama_supplier }}</td>
                                            <td>{{ $pembelian->nama_barang }}</td>
                                            <td>{{ $pembelian->jumlah_barang }}</td>
                                            <td>Rp. {{ number_format($pembelian->harga_barang, 0, ',', '.') }}</td>
                                            <td>Rp. {{ number_format($pembelian->harga_total, 0, ',', '.') }}</td>
                                            <td>
                                                <a class="badge bg-warning" data-bs-toggle="modal" data-bs-target="#editPembelianModal{{ $pembelian->id }}"><i class="bi bi-pencil" style="cursor: pointer;"></i></a>
                                                <form action="{{ route('pembelian.destroy', $pembelian) }}" method="post" style="display: inline-block;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="badge bg-danger border-0" onclick="return confirm('Are You Sure ?')"><i class="bi bi-trash3"></i></button>
                                                </form>
                                            </td>
                                        </tr>

                                        {{-- Modal for editing pembelian --}}
                                        <div class="modal fade" id="editPembelianModal{{ $pembelian->id }}">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Edit Pembelian</h4>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="container-fluid">
                                                            <form method="post" action="{{ route('pembelian.update', $pembelian->id) }}">
                                                                @csrf
                                                                @method('PUT')
                                                                <div class="mb-3">
                                                                    <label class="control-label">Nama Supplier</label>
                                                                    <input type="text" name="nama_supplier" class="form-control rounded-0" value="{{ $pembelian->nama_supplier }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label for="nama_barang" class="form-label">Nama Barang</label>
                                                                    <select class="form-select" name="nama_barang">
                                                                        @foreach ($stocks as $stock)
                                                                            <option value="{{ $stock->nama_barang }}" {{ $stock->nama_barang == $pembelian->nama_barang ? 'selected' : '' }}>{{ $stock->nama_barang }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="control-label">Jumlah Barang</label>
                                                                    <input type="number" name="jumlah_barang" class="form-control rounded-0" value="{{ $pembelian->jumlah_barang }}" required>
                                                                </div>
                                                                <div class="mb-3">
                                                                    <label class="control-label">Harga Barang</label>
                                                                    <input type="text" name="harga_barang" class="form-control rounded-0" value="{{ $pembelian->harga_barang }}" required>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-success">Update Pembelian</button>
                                                                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="addPembelianModal" class="modal fade">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Add Pembelian</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <form method="post" action="{{ route('pembelian.store') }}">
                            @csrf
                            <div class="mb-3">
                                <label class="control-label">Nama Supplier</label>
                                <input type="text" name="nama_supplier" class="form-control rounded-0" required>
                            </div>
                            <div class="mb-3">
                                <label for="nama_barang" class="form-label">Nama Barang</label>
                                <select class="form-select" name="nama_barang">
                                    @foreach ($stocks as $stock)
                                        <option value="{{ $stock->nama_barang }}">{{ $stock->nama_barang }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="control-label">Jumlah Barang</label>
                                <input type="number" name="jumlah_barang" class="form-control rounded-0" required>
                            </div>
                            <div class="mb-3">
                                <label class="control-label">Harga Barang</label>
                                <input type="text" name="harga_barang" class="form-control rounded-0" required>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Tambah Pembelian</button>
                                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
