<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;

    protected $table = 'employee';
    protected $fillable = ['nama', 'alamat', 'telp', 'status'];

    public function gaji()
    {
        return $this->hasMany(Gaji::class);
    }

    public function currentGaji()
    {
        return $this->hasOne(Gaji::class)->latest('created_at');
    }
}
