<?php

namespace App\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Models\Service;
use App\Models\Customer;
use App\Models\Employee;
use App\Models\History;
use App\Models\Stock;

class ServiceController extends Controller
{
    public function index(Request $request)
    {
        if ($request->nopol) {
            $customers = Customer::join('mobil', 'mobil.customer_id', '=', 'customer.id')
                ->where('no_polisi', $request->nopol)
                ->select('customer.*', 'mobil.*', 'mobil.id as mid')
                ->first();
        } else {
            $customers = null;
        }
        $pegawai = Employee::all();
        $stock = Stock::all();
        return view('service.index', compact('customers', 'pegawai', 'stock'));
    }

    public function tambahHistory(Request $request)
    {
        $data = new History();
        $data->kilometer = $request->kilometer;
        $data->customer_id = $request->customer_id;
        $data->employee_id = $request->employee_id;
        $data->no_polisi = $request->no_polisi;
        $data->jenis_mobil = $request->jenis_mobil;
        $data->save();

        $employee = Employee::find($request->employee_id);
        $employee->jumlah_kendaraan = $employee->jumlah_kendaraan + 1;
        $employee->save();
        return redirect('/service/' . $data->id);
    }

    public function service($id)
    {
        $data = History::join('customer', 'customer.id', 'history.customer_id')->join('employee', 'employee.id', 'history.employee_id')->where('history.id', $id)->select('history.*', 'employee.nama', 'customer.nama', 'customer.telp')->first();
        $total = Service::where('id_history', $id)->sum('total_harga');
        $stock = Stock::all();
        $pegawai = Employee::all();
        $service = Service::leftjoin('stock', 'stock.id', 'service.stock_id')->where('id_history', $id)->select('service.*', 'stock.nama_barang', 'stock.harga_barang')->get();
        return view('service.service', compact('data', 'service', 'stock', 'pegawai', 'total'));
    }

    public function tambahService($id)
    {
        $data = new Service();
        $data->stock_id = request('stock_id');
        if (request('stock_id') != null) {
            $stock = Stock::where('id', request('stock_id'))->first();
            $stock->jumlah_barang = $stock->jumlah_barang - request('jumlah');
            $stock->save();
        }
        $data->jasa = request('jasa');
        $data->id_history = $id;
        $data->jumlah = request('jumlah');
        $data->satuan = request('satuan');
        $data->total_harga = request('harga_barang') * request('jumlah');
        $data->save();
        return redirect('/service/' . $id);
    }

    public function updateService($id)
    {
        $ids = request('id_service');
        $data = Service::where('id', $ids)->first();
        if ($data->stock_id == request('stock_id') && $data->stock_id != null) {
            $stock = Stock::where('id', $data->stock_id)->first();
            $stock->jumlah_barang = request('jumlah_barang') - request('jumlah');
            $stock->save();
        } elseif ($data->stock_id != request('stock_id') && $data->stock_id != null) {
            $stock = Stock::where('id', $data->stock_id)->first();
            $stock->jumlah_barang = request('jumlah_barang');
            $stock->save();
            if (request('stock_id') != null) {
                $stockNew = Stock::where('id', request('stock_id'))->first();
                $stockNew->jumlah_barang = $stockNew->jumlah_barang - request('jumlah');
                $stockNew->save();
            } else {
                $stock = Stock::where('id', $data->stock_id)->first();
                $stock->jumlah_barang = request('jumlah_barang');
                $stock->save();
            }
        }elseif($data->stock_id == null && request('stock_id') != null){
            $stockNew = Stock::where('id', request('stock_id'))->first();
                $stockNew->jumlah_barang = $stockNew->jumlah_barang - request('jumlah');
                $stockNew->save();
        }
        $data->stock_id = request('stock_id');
        $data->jasa = request('jasa');
        $data->jumlah = request('jumlah');
        $data->satuan = request('satuan');
        $data->total_harga = request('harga_barang') * request('jumlah');
        $data->save();
        return redirect('/service/' . $id);
    }

    public function deleteService($id)
    {
        $ids = request('id_service');
        $data = Service::where('id', $ids)->first();
        $data->delete();
        return redirect('/service/' . $id);
    }

    public function updateHistory($id, Request $request)
    {
        $data = History::where('id', $id)->first();
        $total = Service::where('id_history', $id)->sum('total_harga');
        $data->harga_total = $total - $total * (request('discount') / 100);
        $data->discount = request('discount');
        $data->save();
        return redirect(route('service.index'));
    }

    public function cekNota(Request $request)
    {
        $data = History::find($request->nota);
        if ($data) {
            return redirect('/service/' . $data->id);
        } else {
            return redirect('/service');
        }
    }
}
