package models

import (
	"github.com/revel/revel"
)

type Mahasiswa struct {
	ID       uint64 `gorm:"default:0;"`
	Email    string `gorm:"size:32; not null;"`
	Nama     string `gorm:"size:32; not null;"`
	Coin     int    `gorm:"default:0;"`
	Powerups int    `gorm:"default:0;"`
	IsAdmin  bool   `gorm:"default:false;"`
}

func (m *Mahasiswa) Validate(v *revel.Validation) {
	v.Required(m.Nama).Message("Nama tidak boleh kosong")
	v.Required(m.Email).Message("Email tidak boleh kosong")

}
