package controllers

import (
	m "skripsi/skripsiBackend/models"

	"database/sql"

	

	"github.com/revel/revel"
)

type JenisSoal struct {
	*revel.Controller
}

func (c JenisSoal) Index() revel.Result {
	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	rows, err := db.Query("SELECT * FROM jenis_soal")
	if err != nil {
		// revel.ERROR.Println("Query gagal:", err)
		return c.RenderText("Query gagal")
	}
	defer rows.Close()

	jenissoals := []m.JenisSoal{}
	for rows.Next() {
		jenissoal := m.JenisSoal{}
		if err := rows.Scan(&jenissoal.ID, &jenissoal.Nama); err != nil {
			// revel.ERROR.Println("Baca data gagal:", err)
			return c.RenderText("Baca data gagal")
		}
		jenissoals = append(jenissoals, jenissoal)
	}

	return c.RenderJSON(jenissoals)
}
