package controllers

import (
	m "skripsi/skripsiBackend/models"

	"database/sql"

	"github.com/go-sql-driver/mysql"
	"github.com/revel/revel"
)

type Room struct {
	*revel.Controller
}

func (c Room) Index(ID_room int) revel.Result {
	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	var rows *sql.Rows

	
	if ID_room > 0 {
		rows, err = db.Query("SELECT * FROM room WHERE id = ?", ID_room)

	}  else {
		rows, err = db.Query("SELECT * FROM room")

	}
	if err != nil {
		// revel.ERROR.Println("Query gagal:", err)
		return c.RenderText("Query gagal")
	}
	defer rows.Close()

	rooms := []m.Room{}
	for rows.Next() {
		room := m.Room{}
		if err := rows.Scan(&room.ID, &room.Kode, &room.PlayerList, &room.KeyPlayer, &room.IDMateri); err != nil {
			// revel.ERROR.Println("Baca data gagal:", err)
			return c.RenderText("Baca data gagal")
		}
		rooms = append(rooms, room)
	}

	return c.RenderJSON(rooms)
}

func (c Room) IndexByMateri(ID_materi int) revel.Result {
	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

		rows, err := db.Query("SELECT * FROM room WHERE ID_materi = ?", ID_materi)

	
	if err != nil {
		// revel.ERROR.Println("Query gagal:", err)
		return c.RenderText("Query gagal")
	}
	defer rows.Close()

	rooms := []m.Room{}
	for rows.Next() {
		room := m.Room{}
		if err := rows.Scan(&room.ID, &room.Kode, &room.PlayerList, &room.KeyPlayer, &room.IDMateri); err != nil {
			// revel.ERROR.Println("Baca data gagal:", err)
			return c.RenderText("Baca data gagal")
		}
		rooms = append(rooms, room)
	}

	return c.RenderJSON(rooms)
}

func (c Room) Create(room m.Room) revel.Result {
	v := c.Validation
	room.Validate(v)
	if v.HasErrors() {
		return c.RenderText("Validasi gagal")
	}

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("INSERT INTO room (kode, player, keyPlayer, ID_materi) VALUES (?, ?, ?, ?)", room.Kode, room.PlayerList, room.KeyPlayer, room.IDMateri)
	if err != nil {
		if mysqlError, ok := err.(*mysql.MySQLError); ok {
			if mysqlError.Number == 1062 {
				return c.RenderText("Kode room sudah ada")
			}
		}
		//  revel.ERROR.Println("Insert data gagal:", err)
		return c.RenderText("Insert data gagal")
	}

	return c.RenderText("Data room berhasil ditambahkan")
}

func (c Room) InsertPlayer(id int,room m.Room) revel.Result {

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()



	_, err = db.Exec("UPDATE ROOM SET player=? WHERE id=?", room.PlayerList, id)
	if err != nil {

		//  revel.ERROR.Println("Insert data gagal:", err)
		return c.RenderText("Update data gagal")
	}

	if len(room.PlayerList) <= 0 {
		c.Delete(id)
	}

	return c.RenderText("Data player baru berhasil ditambahkan")
}

func (c Room) ChangeKeyPlayer(id int,room m.Room) revel.Result {

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("UPDATE ROOM SET keyPlayer=? WHERE id=?", room.KeyPlayer, id)
	if err != nil {

		//  revel.ERROR.Println("Insert data gagal:", err)
		return c.RenderText("Update data gagal")
	}

	return c.RenderText("Data key player baru berhasil ditambahkan")
}

func (c Room) Delete(id int) revel.Result {

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("DELETE FROM room WHERE ID=?", id)
	if err != nil {
		// Handle error here
		return c.RenderText("Delete data gagal")
	}

	return c.RenderText("Data room berhasil dihapus")
}

func (c Room) DeleteByCode(kode string) revel.Result {

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("DELETE FROM room WHERE ID=?", kode)
	if err != nil {
		// Handle error here
		return c.RenderText("Delete data gagal")
	}

	return c.RenderText("Data room berhasil dihapus")
}
