<?php if (isset($component)) { $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da = $component; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Daftar Pegawai
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-6 px-8">

        
        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-100 text-green-800 rounded">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        
        <?php if(Session::has('import_errors')): ?>
            <div class="mb-4 p-4 bg-yellow-100 text-yellow-800 rounded">
                <strong>Beberapa baris gagal diimport:</strong>
                <ul class="list-disc list-inside mt-1">
                    <?php $__currentLoopData = Session::get('import_errors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>Baris <?php echo e($err['baris']); ?>: <?php echo e($err['pesan']); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        
        <form action="<?php echo e(route('pegawai.index')); ?>" method="GET" class="mb-4">
            <div class="flex gap-2">
                <input type="text" name="search" placeholder="Cari nama atau NIP..."
                    value="<?php echo e(request('search')); ?>"
                    class="border rounded px-4 py-2 w-full" />
                <button type="submit" class="bg-blue-500 text-white px-4 py-2 rounded">Cari</button>
            </div>
        </form>

        
        <form action="<?php echo e(route('pegawai.bulkDelete')); ?>" method="POST" onsubmit="return confirm('Yakin ingin menghapus data yang dipilih?')">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>

            <div class="flex justify-between items-center mb-3">
                <a href="<?php echo e(route('pegawai.create')); ?>"
                    class="bg-blue-600 text-white px-4 py-2 rounded">+ Tambah Pegawai</a>
                <button type="submit" class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700">
                    Hapus Terpilih
                </button>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full table-auto border border-gray-300 text-sm">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="border px-3 py-2 text-center">
                                <input type="checkbox" id="select-all">
                            </th>
                            <th class="border px-3 py-2 text-left">Nama</th>
                            <th class="border px-3 py-2 text-left">NIP</th>
                            <th class="border px-3 py-2 text-left">Jabatan</th>
                            <th class="border px-3 py-2 text-left">Divisi</th>
                            <th class="border px-3 py-2 text-left">Status Karyawan</th>
                            <th class="border px-3 py-2 text-left">Status Aktif</th>
                            <th class="border px-3 py-2 text-left">Tanggal Masuk</th>
                            <th class="border px-3 py-2 text-left">Pendidikan</th>
                            <th class="border px-3 py-2 text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $pegawais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pegawai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="<?php echo e(!$pegawai->status_aktif ? 'bg-red-50' : ''); ?>">
                                <td class="border px-3 py-2 text-center">
                                    <input type="checkbox" name="ids[]" value="<?php echo e($pegawai->id); ?>" class="checkbox-item">
                                </td>
                                <td class="border px-3 py-2 text-gray-800"><?php echo e($pegawai->nama); ?></td>
                                <td class="border px-3 py-2 text-gray-800"><?php echo e($pegawai->nip); ?></td>
                                <td class="border px-3 py-2 text-gray-800"><?php echo e($pegawai->jabatan->nama ?? '-'); ?></td>
                                <td class="border px-3 py-2 text-gray-800"><?php echo e($pegawai->divisi ?? '-'); ?></td>
                                <td class="border px-3 py-2 text-gray-800"><?php echo e($pegawai->status_karyawan ?? '-'); ?></td>
                                <td class="border px-3 py-2">
                                    <span class="inline-block px-2 py-1 text-xs rounded-full font-semibold
                                        <?php echo e($pegawai->status_aktif ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-700'); ?>">
                                        <?php echo e($pegawai->status_aktif ? 'Aktif' : 'Resign'); ?>

                                    </span>
                                </td>
                                <td class="border px-3 py-2 text-gray-800">
                                    <?php echo e($pegawai->tanggal_masuk ? \Carbon\Carbon::parse($pegawai->tanggal_masuk)->format('d/m/Y') : '-'); ?>

                                </td>
                                <td class="border px-3 py-2 text-gray-800"><?php echo e($pegawai->pendidikan_terakhir ?? '-'); ?></td>
                                <td class="border px-3 py-2 text-center">
                                    <a href="<?php echo e(route('pegawai.show', $pegawai->id)); ?>"
                                        class="text-blue-600 hover:underline">Detail</a> |
                                    <a href="<?php echo e(route('pegawai.edit', $pegawai->id)); ?>"
                                        class="text-green-600 hover:underline">Edit</a> |
                                    <form action="<?php echo e(route('pegawai.destroy', $pegawai->id)); ?>" method="POST"
                                        class="inline" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="text-red-600 hover:underline">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="px-4 py-2 text-center text-gray-500">Tidak ada data pegawai.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </form>

        <div class="mt-4">
            <?php echo e($pegawais->links()); ?>

        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        document.getElementById('select-all').addEventListener('change', function () {
            const checkboxes = document.querySelectorAll('.checkbox-item');
            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da)): ?>
<?php $component = $__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da; ?>
<?php unset($__componentOriginal8e2ce59650f81721f93fef32250174d77c3531da); ?>
<?php endif; ?>
<?php /**PATH D:\xampp\htdocs\penggajian-app\resources\views/pegawai/index.blade.php ENDPATH**/ ?>