<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\{
    DashboardController,
    PegawaiController,
    GajiController,
    TunjanganController,
    PotonganController,
    UangMakanController,
    StatistikController,
    JabatanController,
    ProfileController,
    GajiImportController,
    PegawaiImportController,
    LaporanController,
    ImportPresensiController,
    HariLiburController
};

// 🌐 Redirect default ke dashboard
Route::get('/', fn () => redirect()->route('dashboard'));

// 🧹 Bulk Delete Pegawai
Route::delete('/pegawai/bulk-delete', [PegawaiController::class, 'bulkDelete'])->name('pegawai.bulkDelete');

// 📄 Rekonsiliasi PPh 21 Tahunan
Route::get('/gaji/rekonsiliasi', [GajiController::class, 'rekonsiliasiTahunan'])->name('gaji.rekonsiliasi');

// 📥 Import Pegawai
Route::get('/pegawai/import', [PegawaiImportController::class, 'form'])->name('pegawai.import.form');
Route::post('/pegawai/import', [PegawaiImportController::class, 'import'])->name('pegawai.import');

// 📥 Import Presensi
Route::get('/presensi/import', [ImportPresensiController::class, 'form'])->name('presensi.import.form');
Route::post('/presensi/import', [ImportPresensiController::class, 'import'])->name('presensi.import');

// 🔁 Recalculate BPJS JHT & JPENS untuk data gaji lama
Route::get('/recalc-bpjs', function () {
    $gajis = \App\Models\Gaji::all();

    foreach ($gajis as $gaji) {
        $gaji_pokok = $gaji->gaji_pokok;
        $bpjs_jht = $gaji_pokok * 0.02;
        $bpjs_jpens = $gaji_pokok * 0.01;

        $gaji->update([
            'pot_bpjs_jht' => $bpjs_jht,
            'pot_bpjs_jpens' => $bpjs_jpens,
        ]);
    }

    return '✅ Perhitungan ulang BPJS JHT & JPENS selesai.';
});

// ✅ 📤 Export Gaji (dipindah ke luar middleware agar bisa diakses langsung)
Route::get('/gaji/export', [GajiController::class, 'export'])->name('gaji.export');

// 🔐 Route dengan proteksi login dan verifikasi
Route::middleware(['auth', 'verified'])->group(function () {

    // 🏠 Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // 📊 Statistik
    Route::get('/statistik', [StatistikController::class, 'index'])->name('statistik');

    // 👨‍💼 CRUD Pegawai
    Route::resource('pegawai', PegawaiController::class);

    // 📊 AJAX: Hitung jumlah hadir dari presensi
    Route::post('/presensi/hitung-hadir', [ImportPresensiController::class, 'hitungHadir'])->name('presensi.hitung.hadir');

    // 💵 CRUD Gaji
    Route::resource('gaji', GajiController::class);
    Route::get('/gaji/import', [GajiImportController::class, 'form'])->name('gaji.import.form');
    Route::post('/gaji/import', [GajiImportController::class, 'import'])->name('gaji.import');

    // 🧾 Slip Gaji
    Route::get('/gaji/{gaji}/slip', [GajiController::class, 'slip'])->name('gaji.slip');
    Route::get('/gaji/slip-pdf/{pegawai}', [GajiController::class, 'slipTotal'])->name('gaji.slip.pdf');
    Route::get('/gaji/slip-total/{pegawai}', [GajiController::class, 'slipTotal'])->name('gaji.slip_total');
    Route::get('/gaji/slip-total/{pegawai}/pdf/{tahun}', [GajiController::class, 'slipTotalPDF'])->name('gaji.slip_total_pdf');

    // 🍱 Uang Makan
    Route::resource('uangmakan', UangMakanController::class)->except(['show']);
    Route::get('/laporan/uang-makan', [UangMakanController::class, 'laporan'])->name('uangmakan.laporan');
    Route::get('/laporan/uang-makan/filter', [UangMakanController::class, 'filter'])->name('uangmakan.filter');
    Route::get('/laporan/uang-makan/cetak', [UangMakanController::class, 'cetakPdf'])->name('uangmakan.cetak');

    // 🏢 Data Jabatan
    Route::resource('jabatan', JabatanController::class);

    // 📋 Laporan Gaji
    Route::get('/laporan/gaji', [LaporanController::class, 'index'])->name('laporan.gaji');
    Route::get('/laporan/gaji/export-excel', [LaporanController::class, 'exportExcel'])->name('laporan.gaji.export');

    // 📆 Hari Libur
    Route::resource('harilibur', HariLiburController::class)->except(['show']);

    // 👤 Profil User
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// 🔐 Autentikasi Laravel Breeze
require __DIR__.'/auth.php';
