<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Statistik Aplikasi
        </h2>
    </x-slot>

    <div class="py-6 px-4 sm:px-6 lg:px-8 space-y-6">
        {{-- 1. Ringkasan angka --}}
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            <x-card title="Total Pegawai" :value="$totalPegawai" icon="users" />
            <x-card title="Pegawai Aktif" :value="$pegawaiAktif" icon="user-check" />
            <x-card title="Pegawai Non-Aktif" :value="$pegawaiNonAktif" icon="user-times" />
            <x-card title="Total Gaji Bulan Ini" :value="number_format($totalGajiBulanIni,0,',','.')" icon="money-bill-wave" />
        </div>

        {{-- 2. Chart --}}
        <div class="bg-white shadow rounded-lg p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Jumlah Pegawai per Jabatan</h3>
            <canvas id="jabatanChart" height="100"></canvas>
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
      document.addEventListener('DOMContentLoaded', () => {
        new Chart(document.getElementById('jabatanChart').getContext('2d'), {
          type: 'bar',
          data: {
            labels: {!! json_encode(array_keys($dataPerJabatan)) !!},
            datasets: [{
              label: 'Jumlah',
              data: {!! json_encode(array_values($dataPerJabatan)) !!},
              backgroundColor: 'rgba(59,130,246,0.5)',
              borderColor:   'rgba(59,130,246,1)',
              borderWidth: 1
            }]
          },
          options: { scales: { y: { beginAtZero: true } } }
        });
      });
    </script>
    @endpush
</x-app-layout>
