<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Edit Data Pegawai
        </h2>
    </x-slot>

    <div class="py-6 px-8">
        <div class="bg-white p-6 rounded shadow">
            @if ($errors->any())
                <div class="mb-4 text-red-600">
                    <ul class="list-disc pl-5">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('pegawai.update', $pegawai->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-4">
                    <label for="nama" class="block font-medium">Nama</label>
                    <input type="text" name="nama" id="nama" class="w-full border-gray-300 rounded-md shadow-sm"
                        value="{{ old('nama', $pegawai->nama) }}" required>
                </div>

                <div class="mb-4">
                    <label for="nip" class="block font-medium">NIP</label>
                    <input type="text" name="nip" id="nip" class="w-full border-gray-300 rounded-md shadow-sm"
                        value="{{ old('nip', $pegawai->nip) }}" required>
                </div>

                <div class="mb-4">
                    <label for="jabatan_id" class="block font-medium">Jabatan</label>
                    <select name="jabatan_id" id="jabatan_id" class="w-full border-gray-300 rounded-md shadow-sm select2" required>
                        <option value="">-- Pilih Jabatan --</option>
                        @foreach ($jabatans as $jabatan)
                            <option value="{{ $jabatan->id }}" {{ $pegawai->jabatan_id == $jabatan->id ? 'selected' : '' }}>
                                {{ $jabatan->nama }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4">
                    <label for="divisi" class="block font-medium">Divisi</label>
                    <input type="text" name="divisi" id="divisi" class="w-full border-gray-300 rounded-md shadow-sm"
                        value="{{ old('divisi', $pegawai->divisi) }}" required>
                </div>

                <div class="mb-4">
                    <label for="status_karyawan" class="block font-medium">Status Karyawan</label>
                    <select name="status_karyawan" id="status_karyawan" class="w-full border-gray-300 rounded-md shadow-sm" required>
                        <option value="Tetap" {{ $pegawai->status_karyawan == 'Tetap' ? 'selected' : '' }}>Tetap</option>
                        <option value="Kontrak" {{ $pegawai->status_karyawan == 'Kontrak' ? 'selected' : '' }}>Kontrak</option>
                    </select>
                </div>

                <div class="mb-6">
                    <label class="block font-medium mb-2">Status Aktif</label>
                    <input type="hidden" name="status_aktif" value="0">
                    <label class="inline-flex items-center cursor-pointer relative">
                        <input type="checkbox" name="status_aktif" id="status_aktif" value="1"
                            class="sr-only peer"
                            {{ old('status_aktif', $pegawai->status_aktif) ? 'checked' : '' }}>
                        <div class="w-11 h-6 bg-gray-200 rounded-full peer peer-checked:bg-green-500
                            after:content-[''] after:absolute after:bg-white after:border after:rounded-full
                            after:h-5 after:w-5 after:transition-all after:duration-200 after:translate-x-1
                            peer-checked:after:translate-x-5">
                        </div>
                        <span class="ml-3 text-sm text-gray-700 peer-checked:text-green-600">
                            Aktif
                        </span>
                    </label>
                    @error('status_aktif')
                        <p class="text-sm text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="mb-4">
                    <label for="tanggal_masuk" class="block font-medium">Tanggal Masuk</label>
                    <input type="date" name="tanggal_masuk" id="tanggal_masuk" class="w-full border-gray-300 rounded-md shadow-sm"
                        value="{{ old('tanggal_masuk', $pegawai->tanggal_masuk) }}">
                </div>

                <div class="mb-4">
                    <label for="pendidikan_terakhir" class="block font-medium">Pendidikan Terakhir</label>
                    <input type="text" name="pendidikan_terakhir" id="pendidikan_terakhir" class="w-full border-gray-300 rounded-md shadow-sm"
                        value="{{ old('pendidikan_terakhir', $pegawai->pendidikan_terakhir) }}">
                </div>

                <div class="mb-4">
                    <label for="status_ptkp" class="block font-medium">Status PTKP</label>
                    <select name="status_ptkp" id="status_ptkp" class="w-full border-gray-300 rounded-md shadow-sm" required>
                        <option value="">-- Pilih Status PTKP --</option>
                        <option value="TK/0" {{ old('status_ptkp', $pegawai->status_ptkp) == 'TK/0' ? 'selected' : '' }}>TK/0 - Tidak Kawin, 0 tanggungan</option>
                        <option value="TK/1" {{ old('status_ptkp', $pegawai->status_ptkp) == 'TK/1' ? 'selected' : '' }}>TK/1 - Tidak Kawin, 1 tanggungan</option>
                        <option value="TK/2" {{ old('status_ptkp', $pegawai->status_ptkp) == 'TK/2' ? 'selected' : '' }}>TK/2 - Tidak Kawin, 2 tanggungan</option>
                        <option value="TK/3" {{ old('status_ptkp', $pegawai->status_ptkp) == 'TK/3' ? 'selected' : '' }}>TK/3 - Tidak Kawin, 3 tanggungan</option>
                        <option value="K/0"  {{ old('status_ptkp', $pegawai->status_ptkp) == 'K/0' ? 'selected' : '' }}>K/0 - Kawin, 0 tanggungan</option>
                        <option value="K/1"  {{ old('status_ptkp', $pegawai->status_ptkp) == 'K/1' ? 'selected' : '' }}>K/1 - Kawin, 1 tanggungan</option>
                        <option value="K/2"  {{ old('status_ptkp', $pegawai->status_ptkp) == 'K/2' ? 'selected' : '' }}>K/2 - Kawin, 2 tanggungan</option>
                        <option value="K/3"  {{ old('status_ptkp', $pegawai->status_ptkp) == 'K/3' ? 'selected' : '' }}>K/3 - Kawin, 3 tanggungan</option>
                    </select>
                </div>

                <div class="mt-6 flex justify-end">
                    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Update</button>
                    <a href="{{ route('pegawai.index') }}" class="ml-3 text-gray-600 hover:underline">Batal</a>
                </div>
            </form>
        </div>
    </div>

    @push('scripts')
        <script>
            $(document).ready(function () {
                $('#jabatan_id').select2({
                    placeholder: "-- Pilih Jabatan --",
                    allowClear: true,
                    width: 'resolve'
                });
            });
        </script>
    @endpush
</x-app-layout>
