<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Laporan Rekap Gaji Bulanan</h2>
    </x-slot>

    <div class="py-4 px-6">
        <form method="GET" class="mb-4">
            <label for="bulan" class="mr-2">Pilih Bulan:</label>
            <input type="month" name="bulan" id="bulan" value="{{ $bulan }}" class="border p-1 rounded">
            <button type="submit" class="ml-2 bg-blue-600 text-white px-3 py-1 rounded">Tampilkan</button>
        </form>

        <a href="{{ route('laporan.gaji.export', ['bulan' => $bulan]) }}" class="bg-green-600 text-white px-3 py-1 rounded inline-block mb-3">
            Export ke Excel
        </a>

        <div class="overflow-x-auto">
            <table class="min-w-full bg-white border">
                <thead>
                    <tr class="bg-gray-100">
                        <th class="px-3 py-2 border">Nama</th>
                        <th class="px-3 py-2 border">Gaji Pokok</th>
                        <th class="px-3 py-2 border">Uang Makan</th>
                        <th class="px-3 py-2 border">Tunjangan</th>
                        <th class="px-3 py-2 border">Total Potongan</th>
                        <th class="px-3 py-2 border">PPh 21</th>
                        <th class="px-3 py-2 border">Total Diterima</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($rekap as $g)
                        <tr>
                            <td class="border px-2">{{ $g->pegawai->nama }}</td>
                            <td class="border px-2">Rp{{ number_format((float) $g->gaji_pokok) }}</td>
                            <td class="border px-2">Rp{{ number_format((float) $g->uang_makan) }}</td>
                            <td class="border px-2">
                                Rp{{ number_format((float) (is_iterable($g->tunjangan) ? $g->tunjangan->sum('jumlah') : ($g->tunjangan->jumlah ?? 0))) }}
                            </td>
                            <td class="border px-2">
                                Rp{{ number_format(
                                    (float) $g->pot_bpjs_kesehatan +
                                    (float) $g->pot_bpjs_ketenagakerjaan +
                                    (float) $g->pot_pph21 +
                                    (float) $g->pot_absen +
                                    (float) $g->pot_pinjaman
                                ) }}
                            </td>
                            <td class="border px-2">Rp{{ number_format((float) $g->pph21_dipotong) }}</td>
                            <td class="border px-2">
                                Rp{{ number_format(
                                    (float) $g->gaji_pokok +
                                    (float) $g->uang_makan +
                                    (float) (is_iterable($g->tunjangan) ? $g->tunjangan->sum('jumlah') : ($g->tunjangan->jumlah ?? 0)) -
                                    (float) $g->pot_bpjs_kesehatan -
                                    (float) $g->pot_bpjs_ketenagakerjaan -
                                    (float) $g->pot_pph21 -
                                    (float) $g->pot_absen -
                                    (float) $g->pot_pinjaman -
                                    (float) $g->pph21_dipotong
                                ) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</x-app-layout>
