<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Daftar Hari Libur</h2>
    </x-slot>

    <div class="py-6 px-8">
        @if (session('success'))
            <div class="mb-4 p-4 bg-green-100 text-green-800 rounded">
                {{ session('success') }}
            </div>
        @endif

        <a href="{{ route('harilibur.create') }}" class="mb-4 inline-block bg-blue-600 text-white px-4 py-2 rounded">+ Tambah Hari Libur</a>

        <div class="overflow-x-auto">
            <table class="min-w-full table-auto border border-gray-300 text-sm">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border px-3 py-2 text-left">Tanggal</th>
                        <th class="border px-3 py-2 text-left">Keterangan</th>
                        <th class="border px-3 py-2 text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($hariliburs as $hari)
                        <tr>
                            <td class="border px-3 py-2">{{ \Carbon\Carbon::parse($hari->tanggal)->format('d/m/Y') }}</td>
                            <td class="border px-3 py-2">{{ $hari->keterangan }}</td>
                            <td class="border px-3 py-2 text-center">
                                <a href="{{ route('harilibur.edit', $hari->id) }}" class="text-green-600 hover:underline">Edit</a> |
                                <form action="{{ route('harilibur.destroy', $hari->id) }}" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline">Hapus</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3" class="px-4 py-2 text-center text-gray-500">Belum ada data hari libur.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            {{ $hariliburs->links() }}
        </div>
    </div>
</x-app-layout>
