<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">Tambah Hari Libur</h2>
    </x-slot>

    <div class="py-6 px-8 max-w-xl">
        <form action="{{ route('harilibur.store') }}" method="POST" class="bg-white shadow rounded p-6">
            @csrf

            <div class="mb-4">
                <label for="tanggal" class="block font-medium">Tanggal</label>
                <input type="date" name="tanggal" id="tanggal" class="form-input w-full" value="{{ old('tanggal') }}" required>
                @error('tanggal')<p class="text-sm text-red-600 mt-1">{{ $message }}</p>@enderror
            </div>

            <div class="mb-4">
                <label for="keterangan" class="block font-medium">Keterangan</label>
                <input type="text" name="keterangan" id="keterangan" class="form-input w-full" value="{{ old('keterangan') }}">
                @error('keterangan')<p class="text-sm text-red-600 mt-1">{{ $message }}</p>@enderror
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Simpan</button>
                <a href="{{ route('harilibur.index') }}" class="ml-3 text-gray-600 hover:underline">Batal</a>
            </div>
        </form>
    </div>
</x-app-layout>